/***************************************************************************
 * logger.h: definition of Logger class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2006-2008 the KTabEdit development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef LOGGER_H
#define LOGGER_H

#include <header.h>

class Logger {
	static bool inst;
	QFile file;
	QTextStream stream;
public:
	Logger();
	~Logger();
	
	Logger& operator<<(QChar c);
	Logger& operator<<(char c);
	Logger& operator<<(signed short i);
	Logger& operator<<(unsigned short i);
	Logger& operator<<(signed int i);
	Logger& operator<<(unsigned int i);
	Logger& operator<<(signed long i);
	Logger& operator<<(unsigned long i);
	Logger& operator<<(float f);
	Logger& operator<<(double f);
	Logger& operator<<(const char *s);
	Logger& operator<<(const QString &s);
	Logger& operator<<(void *ptr);
	Logger& operator<<(const QColor &color);
};

extern Logger ktabLog;

#endif
