/***************************************************************************
 * options.cpp: implementation of Options class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "options.h"

#include "optionspage.h"
#include "optionsmusictheory.h"
#include "optionsmelodyeditor.h"
#include "optionsexportmusixtex.h"
#include "optionsmidi.h"
#include "optionstimidity.h"
#include "optionsprinting.h"
#include "optionsexportascii.h"
#include "optionsscore.h"

Options::Options(TSE3::MidiSchedulerFactory& midiFactory, TSE3::MidiScheduler* &scheduler, KConfig *config, QWidget *parent, char *name, bool modal)
: KDialogBase(TreeList, i18n("Preferences"), Help|Default|Ok|Apply|Cancel, Ok, parent, name, modal, true)
{
	resize(530, 300);
	
	layout.setAutoDelete(true);
	optWidget.setAutoDelete(true);
	optPage.setAutoDelete(true);
	
	optPage.append(addPage(i18n("Music Theory"), 0, SmallIcon("lookandfeel")));
	optPage.append(addPage(i18n("Melody Constructor"), 0, SmallIcon("melodyeditor")));
	optPage.append(addPage(QStringList::split('/', i18n("Export") + "/" + i18n("MusiXTeX")), 0, SmallIcon("musixtex")));
	optPage.append(addPage(i18n("Printing"), 0, SmallIcon("printmgr")));
	optPage.append(addPage(QStringList::split('/', i18n("Export") + "/" + i18n("ASCII")), 0, SmallIcon("ascii")));
	optPage.append(addPage(i18n("Midi"), 0, SmallIcon("midi")));
	optPage.append(addPage(i18n("Timidity"), 0, SmallIcon("Timidity")));
	optPage.append(addPage(i18n("Score"), 0, SmallIcon("Score")));
	
	optWidget.append(new OptionsMusicTheory(config, optPage.at(0)));
	optWidget.append(new OptionsMelodyEditor(config, optPage.at(1)));
	optWidget.append(new OptionsExportMusixtex(config, optPage.at(2)));
	optWidget.append(new OptionsPrinting(config, optPage.at(3)));
	optWidget.append(new OptionsExportAscii(config, optPage.at(4)));
	optWidget.append(new OptionsMidi(midiFactory, scheduler, config, optPage.at(5)));
	optWidget.append(new OptionsTimidity(config, optPage.at(6)));
	optWidget.append(new OptionsScore(config, optPage.at(7)));
	
	// Special weird layout stuff to pack everything
	//
	for (uint i = 0; i < optPage.count(); i++) {
		layout.append(new QVBoxLayout(optPage.at(i), 0, KDialog::spacingHint()));
		layout.at(i)->addWidget(optWidget.at(i));
	}
	
	connect(this, SIGNAL(defaultClicked()), SLOT(defaultBtnClicked()));
	connect(this, SIGNAL(okClicked()), SLOT(applyBtnClicked()));
	connect(this, SIGNAL(applyClicked()), SLOT(applyBtnClicked()));
}

Options::~Options()
{
/*	int i;
	
	for (i = 0; i < 7; i++)
		delete layout[i];
	
	for (i = 0; i < 7; i++) {
		delete optWidget[i];
		delete optPage[i];
	}*/
}

void Options::applyBtnClicked()
{
	for (int i = 0; i < optPage.count(); i++)
		optWidget.at(i)->applyBtnClicked();
}

void Options::defaultBtnClicked()
{
	for (int i = 0; i < optPage.count(); i++)
		optWidget.at(i)->defaultBtnClicked();
}
