/***************************************************************************
 * optionsexportascii.h: implementation of OptionsExportAscii class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef OPTIONSEXPORTASCII_H
#define OPTIONSEXPORTASCII_H

#include <header.h>

#include "optionspage.h"

//! Options page for ASCII tabulature export setup.
/*!
	Allows to set duration display (number of spaces in ASCII
	tabulature rendering) and page width.
*/
class OptionsExportAscii: public OptionsPage {
	Q_OBJECT
public:
	/*!
		Inits the widget and store the config var.
	*/
	OptionsExportAscii(KConfig *conf, QWidget *parent = 0, const char *name = 0);
	
	/*!
		Click on button ok.
	*/
	virtual void applyBtnClicked();
	
	/*!
		Default button clicked.
	*/
	virtual void defaultBtnClicked();
private:
	QVButtonGroup *durationGroup;
	QRadioButton *duration[5];
	QSpinBox *pageWidth;
	QCheckBox *always;
};

#endif
