/***************************************************************************
 * optionspage.h: implementation of OptionsPage class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef OPTIONSPAGE_H
#define OPTIONSPAGE_H

#include <header.h>

//! Abstract base class for all options pages.
/*!
	Defines basic interfaces to store configuration object and virtual
	methods to "store settings" and "reset to default".
*/
class OptionsPage: public QWidget {
	Q_OBJECT
public:
	/*!
		Inits the widget and store the config var.
	*/
	OptionsPage(KConfig *conf, QWidget *parent = 0, const char *name = 0);

public slots:
	/*!
		Standard button callback on "OK" and "Apply" buttons to store
		information from dialog to permanent storage in config object.
	*/
	virtual void applyBtnClicked() = 0;
	
	/*!
		Standard button callback on "Default" button to reset all
		dialog settings to sane defaults. Doesn't do any thing to
		config object, touches only the dialog.
	*/
	virtual void defaultBtnClicked() = 0;

protected:
	/*!
		Convenience storage to KConfig configuration object that
		represents application-wide configuration.
	*/
	KConfig *config;
};

#endif
