/***************************************************************************
 * optionsprinting.cpp: implementation of OptionsPrinting class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "optionsprinting.h"
#include "settings.h"

OptionsPrinting::OptionsPrinting(KConfig *conf, QWidget *parent, const char *name)
	: OptionsPage(conf, parent, name)
{
	// Create option widgets

	styleGroup = new QVButtonGroup(i18n("Style"), this);
	style[0] = new QRadioButton(i18n("Tabulature"), styleGroup);
	style[1] = new QRadioButton(i18n("Notes"), styleGroup);
	style[2] = new QRadioButton(i18n("Tabulature (full) and notes"), styleGroup);
	style[3] = new QRadioButton(i18n("Tabulature (minimum) and notes (not implemented)"), styleGroup);

	// Set widget layout

    QHBoxLayout *box = new QHBoxLayout(this);
	box->addWidget(styleGroup);
	box->activate();

	// Fill in current config

	styleGroup->setButton(Settings::printingStyle());
}

void OptionsPrinting::defaultBtnClicked()
{
	styleGroup->setButton(0);
}

void OptionsPrinting::applyBtnClicked()
{
	config->setGroup("Printing");
	config->writeEntry("Style", styleGroup->id(styleGroup->selected()));
}
