/***************************************************************************
 * playbacktracker.h: implementation of PlayBacktracker class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef PLAYBACKTRACKER_H
#define PLAYBACKTRACKER_H

#include <header.h>

class SongView;
class TabBar;
class TrackPos;

class PlaybackTracker: public TSE3::TransportCallback {
public:
	PlaybackTracker(SongView *sv);
	
	void resetCursor();
	
	virtual void Transport_MidiOut(TSE3::MidiCommand c);
	virtual void Transport_MidiIn(TSE3::MidiCommand c);
	
	static const uint playBackTrackCmd;
	
private:
	/*
		Converts the midi channel number to the internal channel
	*/
	uint midiChanToIntChan(uint channel);
	
	/*
		Go to the next time.
	*/
	void nextTime(const TabBar& bar, uint channel);
	
	SongView *songView;
	bool drumTrack;
	uint drumTrackNb;
	int midiPort;
	QValueVector<TrackPos> trackPos;
};

#endif // PLAYBACKTRACKER_H
