#ifndef __SEQUENCER__
#define __SEQUENCER__

#include <alsa/asoundlib.h>

#include <qvaluelist.h> 

class SequencerAlsa
{
public:
	SequencerAlsa() throw(const char*);
	
	uint countDevice() const;
	QString deviceName(uint n) const throw(const char*);
	unsigned char client(uint n) const throw(const char*);
	unsigned char port(uint n) const throw(const char*);
	
	void openDevice(uint n) throw(const char*);
	void closeDevice(uint n) throw(const char*);
	
	void scanDevices() throw(const char*);
	
	void noteOn(char channel, char note, char velocity);
	void noteOff(char channel, char note, char velocity);
	
	void changePatch(uchar channel, uchar patch);
	
	void setTempo(uint tempo);
private:
	void timerSend(uint type);
	
	static bool init;
	
	struct SequencerContext {
		snd_seq_t* handle;
		int queue;
		snd_seq_addr_t address;
		int port;
		snd_seq_port_subscribe_t *subs;
	};
	
	struct AlsaDevice {
		bool open;
		snd_seq_addr_t address;
		QString name;
		unsigned char port;
		unsigned char client;
	};
	
	QValueList<AlsaDevice> listAlsaDevice;
	SequencerContext context;
};

#endif
