/***************************************************************************
 * setsong.cpp: implementation of SetSong class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "setsong.h"

using namespace std;

SetSong::SetSong(const TabProperties &_properties, QWidget *parent, const char *name):
 QDialog(parent, name, TRUE), title(this), author(this), transcriber(this),
 comments(this), tempo(this), title_l(&title, i18n("&Title:"), this), author_l(&author, i18n("&Author:"), this),
 transcriber_l(&transcriber, i18n("&Transcriber:"), this), comments_l(&comments, i18n("&Comments:"), this),
 tempo_l(&tempo, i18n("T&empo:"), this), ok(i18n("OK"), this),
 cancel(i18n("Cancel"), this), grid(this, 6, 2, 10),
 properties(_properties)
{

	connect(&ok, SIGNAL(clicked()), SLOT(accept()));
	connect(&cancel, SIGNAL(clicked()), SLOT(reject()));

	grid.addWidget(&title_l, 0, 0);
	grid.addWidget(&title, 0, 1);
	grid.addWidget(&author_l, 1, 0);
	grid.addWidget(&author, 1, 1);
	grid.addWidget(&transcriber_l, 2, 0);
	grid.addWidget(&transcriber, 2, 1);
	grid.addWidget(&comments_l, 3, 0);
	grid.addWidget(&comments, 3, 1);
	grid.addWidget(&tempo_l, 4, 0);
	grid.addWidget(&tempo, 4, 1);

	grid.addLayout(&buttonHBox, 5, 1);
	buttonHBox.addWidget(&ok);
	buttonHBox.addWidget(&cancel);

	grid.setRowStretch(3, 1);
	grid.setColStretch(1, 1);
	grid.addColSpacing(0, 90);
	
	for (int i = 0; i < 4; i++)
		grid.addRowSpacing(i, 20);
	
	grid.addRowSpacing(4, 30);

	grid.activate();

	title.setText(properties.title());
	author.setText(properties.author());
	transcriber.setText(properties.transcriber());
	comments.setText(properties.instructions());
	tempo.setValue(properties.tempo());

	setMinimumSize(250, 170);
	resize(400, 300);
	setCaption(i18n("Song properties"));
}

void SetSong::setProperties(const TabProperties &_properties)
{
	properties = _properties;
}

TabProperties SetSong::getProperties() const
{
	TabProperties tempProperties;

	tempProperties.setTitle(title.text());
	tempProperties.setAuthor(author.text());
	tempProperties.setTranscriber(transcriber.text());
	tempProperties.setInstructions(comments.text());
	tempProperties.setTempo(tempo.value());

	return tempProperties;
}
