/***************************************************************************
 * settabdrum.h: implementation of SetTabDrum class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef SETTABDRUM_H
#define SETTABDRUM_H

#include <header.h>

#include "global.h"

/*!
	TODO
*/
class SetTabDrum: public QWidget {
    Q_OBJECT
public:
	/*!
		TODO
	*/
	SetTabDrum(QWidget *parent=0, const char *name=0);
	/*!
		TODO
	*/
	void setDrums(int n) { dr->setValue(n); };
		
	/*!
		TODO
	*/
	void setTune(uchar x, uchar n) { tuner[x]->setValue(n); };
		
	/*!
		TODO
	*/
	int drums() { return dr->value(); };
		
	/*!
		TODO
	*/
	uchar tune(uchar x) { return tuner[x]->value(); };
	
public slots:
    void stringChanged(int n);

private:
    virtual void resizeEvent(QResizeEvent *e);
    void reposTuners();

    QSpinBox *dr;
    QSpinBox *tuner[MAX_STRINGS];
	QLineEdit *tname[MAX_STRINGS];
    int oldst;
};

#endif
