/***************************************************************************
 * settings.h: implementation of Settings class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#include <header.h>

//! Pure static class to manage configuration stuff.
/*!
	Has static storage place (instead of global variable) for
	application-wide configuration variable and methods to quickly
	access necessary configuration properties.
 */
class Settings {
public:
	/*!
		Cached configuration access variable
	*/
	static KConfig *config;
	
	/*!
		Returns name of note in currently selected note naming
		convention.
	*/
	static QString noteName(int);
	
	/*!
		Returns name of maj7 step as stated in currently selected
		naming convertion.
	*/
	static QString maj7Name();
	
	/*!
		Returns symbol to represent flats as stated in currently
		selected naming convertion.
	*/
	static QString flatName();
	
	/*!
		Returns symbol to represent sharps as stated in currently
		selected naming convertion.
	*/
	static QString sharpName();
	
	/*!
		Global MIDI port selected for output.
	*/
	static QString midiName();
	
	/*!
		Global MIDI port selected for output.
	*/
	static QString midiPort();
	
	/*!
		Global MIDI port selected for output.
		\return 0 if there is no midi configuration
	*/
	static int midiPortNumber();
	
	/*!
		Global MIDI port selected for output.
	*/
	static bool midiReadable();
	
	/*!
		Global MIDI port selected for output.
	*/
	static bool midiWriteable();
	
	/*!
		Global MIDI port selected for output.
	*/
	static bool midiTimidity();
	
	/*!
		MusiXTeX settings
	*/
	static int texTabSize();
	
	/*!
		I DON'T KNOW
	*/
	static bool texShowBarNumber();
	
	/*!
		I DON'T KNOW
	*/
	static bool texShowStr();
	
	/*!
		I DON'T KNOW
	*/
	static bool texShowPageNumber();
	
	/*!
		I DON'T KNOW
	*/
	static bool texExportMode();
	
	/*!
		Printing style
	*/
	static int printingStyle();
	
	/*!
		Melody editor
	*/
	static int melodyEditorInlay();
	
	/*!
		Action code for melody editor button num pressed.
	*/
	static int melodyEditorAction(int num);
	
	/*!
		Need to advance for melody editor button num pressed.
	*/
	static bool melodyEditorAdvance(int num);
	
	static QString timidityPath();
	static int timidityBuffer();
	static int timidityFragment();
	static QString timidityOutput();
	static QString timidityChorus();
	static QString timidityDelay();
	static QString timidityReverb();
	static QString timidityVlpf();
	static int timidityNoise();
	static QString timidityResamp();
	static int timidityFrequency();
	static bool timidityRealTimeEnable();
	static int timidityRealTime();
	
	/*
		True if the assistant was launched
	*/
	static bool assistant();
	
	/*
		Font settings
	*/
	static QString titleFont();
	static QFont::Weight titleWeight();
	static bool titleItalic();
	static int titleSize();
	
	static QString subTitleFont();
	static QFont::Weight subTitleWeight();
	static bool subTitleItalic();
	static int subTitleSize();
	
	static QString textAndTabFont();
	static QFont::Weight textAndTabWeight();
	static bool textAndTabItalic();
	static int textAndTabSize();
	
	static QString timeSignatureFont();
	static QFont::Weight timeSignatureWeight();
	static bool timeSignatureItalic();
	static int timeSignatureSize();
	
private:
	static QString noteNames[9][12];
};

#endif
