/***************************************************************************
 * songprint.cpp: implementation of SongPrint class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2004 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "accidentals.h"
#include "songprint.h"
#include "tabsong.h"
#include "tabtrack.h"
#include "settings.h"
#include "track/trackview.h"

// SongPrint constructor
//
SongPrint::SongPrint()
{
}

// SongPrint destructor

SongPrint::~SongPrint()
{
}

// print TabSong song on KPrinter printer
//
void SongPrint::printSong(KPrinter *printer, TabSong *song)
{
	uint nbPages = 0;
	const int dpi = printer->resolution();
	QSize trackResolution(static_cast<int>(8.26 * dpi), static_cast<int>(11.7 * dpi));
	QPainter painter(printer);
	QWMatrix matrix;
	QCanvas* printCanvas = new QCanvas();
	QRect i;
	TrackView* trackPrint = new TrackView(printCanvas, song, dpi, 1.016, 1.016, trackResolution, false);
	
	trackPrint->setDrawEffects(false);
	trackPrint->setCurrentTrack(song->first());
	
	const QRect canvasRect(printCanvas->rect());
	
	i.setTop(0);
	i.setBottom(trackResolution.height());
	
	i.setLeft(0);
	i.setRight(canvasRect.right());
	
	QPaintDeviceMetrics pdm(printer);
	
	kdDebug() << "Page size : " << printer->pageSize() << "\n";
	kdDebug() << "Margins : " << printer->margins() << "\n";
	kdDebug() << "\n";
	kdDebug() << "Height : " << pdm.height() << "\n";
	kdDebug() << "Width : " << pdm.width() << "\n";
	kdDebug() << "resolution : " << dpi << "\n";
	kdDebug() << "\n";
	kdDebug() << "Height : " << trackResolution.height() << "\n";
	kdDebug() << "Width : " << trackResolution.width() << "\n";
	
/*	matrix.scale(static_cast<double>(pdm.width()) / static_cast<double>(trackResolution.width()),
				 static_cast<double>(pdm.height()) / static_cast<double>(trackResolution.height()));
	painter.setWorldMatrix(matrix);*/
	
	while (nbPages < trackPrint->pages()) {
		printCanvas->drawArea(i, &painter, false);
		
		painter.translate(0, -trackResolution.height());
		
		nbPages++;
		
		i.setTop(nbPages * trackResolution.height());
		i.setBottom((nbPages + 1) * trackResolution.height());
		
		if (nbPages < trackPrint->pages())
			printer->newPage();
	}
	
	delete trackPrint;
	delete printCanvas;
}
