#include "songkey.h"

SongKey::SongKey()
: k(7), minorClef(false)
{
}

SongKey::~SongKey()
{
}

void SongKey::setKey(QChar c)
{
	k = c;
}

QChar SongKey::key() const
{
	return k;
}

QString SongKey::nameOfKey() const
{
	if (!minorClef) {
		switch (k) {
			case -7:
				return "Cb";
			case -6:
				return "Gb";
			case -5:
				return "Db";
			case -4:
				return "Ab";
			case -3:
				return "Eb";
			case -2:
				return "Bb";
			case -1:
				return "F";
			case 0:
				return "C";
			case 1:
				return "G";
			case 2:
				return "D";
			case 3:
				return "A";
			case 4:
				return "E";
			case 5:
				return "B";
			case 6:
				return "F#";
			case 7:
				return "C#";
		}
	} else {
		switch (k) {
			case -7:
				return "Abm";
			case -6:
				return "Ebm";
			case -5:
				return "Bbm";
			case -4:
				return "Fm";
			case -3:
				return "Cm";
			case -2:
				return "Gm";
			case -1:
				return "Dm";
			case 0:
				return "Am";
			case 1:
				return "Em";
			case 2:
				return "Bm";
			case 3:
				return "F#m";
			case 4:
				return "D#m";
			case 5:
				return "G#m";
			case 6:
				return "D#m";
			case 7:
				return "A#m";
		}
	}
	
	return "Bad key";
}

void SongKey::setMinor(bool i)
{
	minorClef = i;
}

bool SongKey::isMinor() const
{
	return minorClef;
}
