/***************************************************************************
 * songkey.h: implementation of TabProperties class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef SONGKEY_H
#define SONGKEY_H

#include <header.h>

class SongKey
{
public:
	/*
		Create a new key.
	*/
	SongKey();
	
	/*
		Does nothing.
	*/
	virtual ~SongKey();
	
	/*
		Set the key.
	*/
	virtual void setKey(QChar c);
	
	/*
		Get the key.
	*/
	virtual QChar key() const;
	
	/*
		Return the name of the key.
	*/
	virtual QString nameOfKey() const;
	
	/*
		Set the mode major or minor.
	*/
	virtual void setMinor(bool i);
	
	/*
		Get the mode major or minor.
	*/
	virtual bool isMinor() const;
	
private:
	QChar k;
	bool minorClef;
};

#endif
