#include "tabbarproperties.h"

TabBarProperties::TabBarProperties()
: repeat(false), close(false), alt(false), repeatStartProp(false),
  repetitionsProp(0), alternateEndingsProp(0), doubleBarProp(false)
{
}

TabBarProperties::~TabBarProperties()
{
}

void TabBarProperties::setColor(const QColor& i)
{
	markerColor = i;
}

QColor TabBarProperties::color() const
{
	return markerColor;
}

void TabBarProperties::setMarker(const QString& s)
{
	markerName = s;
}

QString TabBarProperties::marker() const
{
	return markerName;
}

void TabBarProperties::setRepeatBar(bool b)
{
	repeat = b;
}

bool TabBarProperties::isRepeatBar() const
{
	return repeat;
}

void TabBarProperties::setCloseBar(bool b, QChar c)
{
	close = b;
	volta = c;
}

bool TabBarProperties::isCloseBar() const
{
	return close;
}

void TabBarProperties::setAltBar(bool b)
{
	alt = b;
}

bool TabBarProperties::isAltBar() const
{
	return alt;
}

void TabBarProperties::setRepeatStart(bool b)
{
	repeatStartProp = b;
}

bool TabBarProperties::isRepeatStart() const
{
	return repeatStartProp;
}

void TabBarProperties::setRepetitions(int i)
{
	repetitionsProp = i;
}

int TabBarProperties::repetitions() const
{
	return repetitionsProp;
}

void TabBarProperties::setAlternateEndings(int i)
{
	alternateEndingsProp = i;
}

int TabBarProperties::isAlternateEndings() const
{
	return alternateEndingsProp;
}

void TabBarProperties::setDoubleBar(bool b)
{
	doubleBarProp = b;
}

bool TabBarProperties::isDoubleBar() const
{
	return doubleBarProp;
}
