/***************************************************************************
 * tabbar.h: implementation of TabBar class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABBARPROPERTIES_H
#define TABBARPROPERTIES_H

#include <header.h>

#include "songkey.h"
#include "timesignature.h"

//! Represents bar properties.
/*!
	Stores repeat bars, time signatures, armor and maker.
*/
class TabBarProperties : public SongKey, public TimeSignature {
public:
	/*!
		This constructor inits this class with a time signature 4/4 and
		add an empty note.
	*/
	TabBarProperties();
	virtual ~TabBarProperties();
	
	virtual void setColor(const QColor& i);
	virtual QColor color() const;
	
	virtual void setMarker(const QString& s);
	virtual QString marker() const;
	
	virtual void setRepeatBar(bool b);
	virtual bool isRepeatBar() const;
	
	virtual void setCloseBar(bool b, QChar v);
	virtual bool isCloseBar() const;
	
	virtual void setAltBar(bool b);
	virtual bool isAltBar() const;
	
	virtual void setRepeatStart(bool b);
	virtual bool isRepeatStart() const;
	
	virtual void setRepetitions(int i);
	virtual int repetitions() const;
	
	virtual void setAlternateEndings(int i);
	virtual int isAlternateEndings() const;
	
	virtual void setDoubleBar(bool b);
	virtual bool isDoubleBar() const;
private:
	QColor markerColor;
	QString markerName;
	
	bool repeat;
	
	bool close;
	QChar volta;
	
	bool alt;
	
	bool repeatStartProp;
	int repetitionsProp;
	int alternateEndingsProp;
	bool doubleBarProp;
};

#endif
