/***************************************************************************
 * tabbeateffects.h: implementation of TabBeatEffects class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABBEATEFFECTS_H
#define TABBEATEFFECTS_H

#include "pickstroke.h"
#include "tabbend.h"

class TabBeatEffects : public TabBend
{
public:
	TabBeatEffects();
	
	void setRasgueado(bool b);
	bool isRasgueado() const;
	
	void setPickStroke(PickStroke p);
	PickStroke pickstroke() const;
	
	void setTremolo(int i);
	int tremolo() const;
	
	void setTapping(bool b);
	bool isTapping() const;
	
	void setPopping(bool b);
	bool isPopping() const;
	
	void setSlapping(bool b);
	bool isSlapping() const;
	
	void setStroke(bool b);
	bool isStroke() const;
	
	void setUpStroke(int i);
	int upStroke() const;
	
	void setDownStroke(int i);
	int downStroke() const;
	
	void setVibrato(bool b);
	bool isVibrato() const;
	
	void setWideVibrato(bool b);
	bool isWideVibrato() const;
	
	void setNaturalHarmonic(bool b);
	bool isNaturalHarmonic() const;
	
	void setArtificialHarmonic(bool b);
	bool isArtificialHarmonic() const;
	
	void setFadeIn(bool b);
	bool isFadeIn() const;
	
private:
	bool rasgueado;
	
	PickStroke pickStrokeBeat;
	
	int tremoloValue;
	
	bool tapping;
	bool popping;
	bool slapping;
	
	bool stroke;
	unsigned char upStrokeBeat, downStrokeBeat;
	
	bool vibrato;
	bool wideVibrato;
	bool naturalHarmonic;
	bool artificialHarmonic;
	bool fadeIn;
};

#endif
