#include "tabbend.h"
#include <iostream>

TabBend::TabBend()
: bendTypeEffect(NoneBend), bendValueEffect(0)
{
}

void TabBend::setBendType(TabBend::BendType b)
{
	bendTypeEffect = b;
}

TabBend::BendType TabBend::bendType() const
{
	return bendTypeEffect;
}

void TabBend::setBendValue(int i)
{
	bendValueEffect = i;
}

int TabBend::bendValue() const
{
	return bendValueEffect;
}

QString TabBend::bendValueToString() const
{
	switch (bendValueEffect) {
	case 25:
		return "1/4";
	case 50:
		return "1/2";
	case 75:
		return "3/4";
	case 100:
		if (bendTypeEffect < Dip)
			return "full";
		else
			return "1";
	case 125:
		return "1 1/4";
	case 150:
		return "1 1/2";
	case 175:
		return "1 3/4";
	case 200:
		return "2";
	case 225:
		return "2 1/4";
	case 250:
		return "2 1/2";
	case 275:
		return "2 3/4";
	case 300:
		return "3";
	case 350:
		return "3 1/2";
	case 400:
		return "4";
	case 450:
		return "4 1/2";
	case 500:
		return "5";
	case 550:
		return "5 1/2";
	case 600:
		return "6";
	}
	
	std::cerr << "BendValueEffect = " << bendValueEffect << "\n";
	return "unknow bend value";
}

void TabBend::setBendPoint(const QValueList<TabBendPoint>& p)
{
	bendPointList = p;
}

const QValueList<TabBendPoint>& TabBend::bendPoint() const
{
	return bendPointList;
}
