#include "tabchord.h"

TabChord::TabChord()
: sharpChord(false), rootChord(0), typeChord(0), nineElevenThirteenChord(noneExtention),
  bassChord(0), augmentedDiminishedChord(noneAugmentedDiminished), addedNoteChord(0),
  baseFretChord(0), fiveChord(0), nineChord(0), elevenChord(0), base(0), fretChord(6),
  barres(0), barreFretChord(5), barreStartChord(5),  barreEndChord(5), fingeringChord(7),
  showDiag(false)
{
}

void TabChord::setName(const QString& s)
{
	nameChord = s;
}

QString TabChord::name() const
{
	return nameChord;
}

void TabChord::setSharp(bool b)
{
	sharpChord = b;
}

bool TabChord::isSharp() const
{
	return sharpChord;
}

void TabChord::setRoot(uchar c)
{
	rootChord = c;
}

uchar TabChord::root() const
{
	return rootChord;
}

void TabChord::setType(uchar c)
{
	typeChord = c;
}

uchar TabChord::type() const
{
	return typeChord;
}

void TabChord::setNineElevenThirteen(ExtentionChord c)
{
	nineElevenThirteenChord = c;
}

TabChord::ExtentionChord TabChord::nineElevenThirteen() const
{
	return nineElevenThirteenChord;
}

void TabChord::setBass(uchar c)
{
	bassChord = c;
}

uchar TabChord::bass() const
{
	return bassChord;
}

void TabChord::setAugmentedDiminished(AugmentedDiminished a)
{
	augmentedDiminishedChord = a;
}

TabChord::AugmentedDiminished TabChord::augmentedDiminished() const
{
	return augmentedDiminishedChord;
}

void TabChord::setAddedNote(uchar c)
{
	addedNoteChord = c;
}

uchar TabChord::addedNote() const
{
	return addedNoteChord;
}

void TabChord::setTonalityFive(uchar c)
{
	fiveChord = c;
}

uchar TabChord::tonalityFive() const
{
	return fiveChord;
}

void TabChord::setTonalityNine(uchar c)
{
	nineChord = c;
}

uchar TabChord::tonalityNine() const
{
	return nineChord;
}

void TabChord::setTonalityEleven(uchar c)
{
	elevenChord = c;
}

uchar TabChord::tonalityEleven() const
{
	return elevenChord;
}

void TabChord::setBaseFret(long l)
{
	base = l;
}

long TabChord::baseFret() const
{
	return base;
}

void TabChord::setFret(uchar c, long l)
{
	fretChord[c] = l;
}

long TabChord::fret(uchar c) const
{
	return fretChord[c];
}

void TabChord::setNumBarres(uchar c)
{
	barres = c;
}

uchar TabChord::numBarres() const
{
	return barres;
}

void TabChord::setBarreFret(uchar c, uchar d)
{
	barreFretChord[c] = d;
}

uchar TabChord::barreFret(uchar c) const
{
	return barreFretChord[c];
}

void TabChord::setBarreStart(uchar c, uchar d)
{
	barreStartChord[c] = d;
}

uchar TabChord::barreStart(uchar c) const
{
	return barreStartChord[c];
}

void TabChord::setBarreEnd(uchar c, uchar d)
{
	barreEndChord[c] = d;
}

uchar TabChord::barreEnd(uchar c) const
{
	return barreEndChord[c];
}

void TabChord::setFingering(uchar c, uchar d)
{
	fingeringChord[c] = d;
}

uchar TabChord::fingering(uchar c) const
{
	return fingeringChord[c];
}

void TabChord::setShowDiagram(bool b)
{
	showDiag = b;
}

bool TabChord::isShowDiagram() const
{
	return showDiag;
}
