/***************************************************************************
 * tablyrics.h: implementation of TabLyrics class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABLYRICS_H
#define TABLYRICS_H

#include <header.h>

/*
	The class TabLyrics describes the lyrics.
*/
class TabLyrics {
public:
	/*
		Create a new TabLyrics
	*/
	TabLyrics();
	
	/*
		Does nothing
	*/
	virtual ~TabLyrics();
	
	/*
		Set the track of the lyrics.
	*/
	virtual void setLyricsTrack(int i);
	
	/*
		Get the track of the lyrics.
	*/
	virtual int lyricsTrack() const;
	
	/*
		Set a measure j at the index i.
	*/
	virtual void setLyricsMeasure(int i, int j);
	
	/*
		Get a measure at the index i.
	*/
	virtual int lyricsMeasure(int i) const;
	
	/*
		Set the ith line of the lyrics.
	*/
	virtual void setLyrics(int i, const QString& s);
	
	/*
		Get the ith line of the lyrics.
	*/
	virtual QString lyrics(int i) const;
	
private:
	int lyricsTrackProp;
	QValueVector<int> lyricsMeasureProp;
	QValueVector<QString> lyricsProp; 
};

#endif
