#include "tabmixtablechanges.h"

TabMixTableChanges::TabMixTableChanges()
: instrumentMix(-1), volumeMix(-1), balanceMix(-1),
  chorusMix(-1), reverbMix(-1), phaserMix(-1), tremoloMix(-1),
  tempoMix(-1)
{
}

void TabMixTableChanges::setInstrument(int i)
{
	if (i < 0 || i > 255)
		return ;
	
	instrumentMix = i;
}

int TabMixTableChanges::instrument() const
{
	return instrumentMix;
}

void TabMixTableChanges::setVolume(int i)
{
	if (i < 0)
		return ;
	
	volumeMix = i;
}

int TabMixTableChanges::volume() const
{
	return volumeMix;
}

void TabMixTableChanges::setBalance(int i)
{
	balanceMix = i;
}

int TabMixTableChanges::balance() const
{
	return balanceMix;
}

void TabMixTableChanges::setChorus(int i)
{
	chorusMix = i;
}

int TabMixTableChanges::chorus() const
{
	return chorusMix;
}

void TabMixTableChanges::setReverb(int i)
{
	reverbMix = i;
}

int TabMixTableChanges::reverb() const
{
	return reverbMix;
}

void TabMixTableChanges::setPhaser(int i)
{
	phaserMix = i;
}

int TabMixTableChanges::phaser() const
{
	return phaserMix;
}

void TabMixTableChanges::setTremolo(int i)
{
	tremoloMix = i;
}

int TabMixTableChanges::tremolo() const
{
	return tremoloMix;
}

void TabMixTableChanges::setTempo(int i)
{
	tempoMix = i;
}

int TabMixTableChanges::tempo() const
{
	return tempoMix;
}
