/***************************************************************************
 * tabnote.h: implementation of TabNote class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/
 
#ifndef __TABNOTE__
#define __TABNOTE__

#include "tabbend.h"
#include "tabduration.h"
#include "tabdynamic.h"
#include "tabgracenote.h"
#include "tabexception.h"
#include "tabharmonic.h"
#include "tabslide.h"
#include "tabtrill.h"

class TabNote : public TabBend, public TabGraceNote, public TabTrill {
public:
	enum Fingering {
		UnknownFingering = -2,
		NoneFingering = -1,
		Thumb = 0,
		Index = 1,
		MiddleFinger = 2,
		RingFinger = 3,
		LittleFinger = 4
	};
	
	TabNote();
	
	void setFret(unsigned char c);
	unsigned char fret() const;
	
	void setDuration(Duration c);
	Duration duration() const;
	
	void setEmpty(bool b);
	bool isEmpty() const;
	
	void setNTuplet(unsigned char c);
	unsigned char nTuplet() const;
	
	void setAccentuated(bool b);
	bool isAccentuated() const;
	
	void setDotted(bool b);
	bool isDotted() const;
	
	void setGhostNote(bool b);
	bool isGhostNote() const;
	
	void setTieNote(bool b);
	bool isTieNote() const;
	
	void setDeadNote(bool b);
	bool isDeadNote() const;
	
	void setHammerOnPullOff(bool b);
	bool isHammerOnPullOff() const;
	
	void setSlide(bool b);
	bool isSlide() const;
	
	void setLetRing(bool b);
	bool isLetRing() const;
	
	void setDynamic(Dynamic d);
	Dynamic dynamic() const;
	
	void setFingeringLeft(TabNote::Fingering f);
	TabNote::Fingering fingeringLeft() const;
	
	void setFingeringRight(TabNote::Fingering f);
	TabNote::Fingering fingeringRight() const;
	
	void setLeftHandVibrato(bool b);
	bool isLeftHandVibrato() const;
	
	void setPalmMute(bool b);
	bool isPalmMute() const;
	
	void setStaccato(bool b);
	bool isStaccato() const;
	
	void setSlide(Slide s);
	Slide slide() const;
	
	void setTremoloPicking(char c);
	char tremoloPicking() const;
	
	void setHarmonic(Harmonic h);
	Harmonic harmonic() const;
private:
	bool accentuated;
	bool dotted;
	bool ghostNote;
	bool tieNote;
	bool deadNote;
	bool hammerOnPullOff;
	bool isSlideNote;
	bool letRing;
	Dynamic dynamicNote;
	TabNote::Fingering fingeringLeftNote;
	TabNote::Fingering fingeringRightNote;
	
	unsigned char nTupletNote;
	unsigned char fretNumber;
	Duration durationNote;
	
	bool emptyNote;
	
	char tremolo;
	Slide slideNote;
	bool leftHandVibratoNote;
	bool palmMuteNote;
	bool staccato;
	Harmonic harmonicNote;
};
 
#endif
