/***************************************************************************
 * tabproperties.h: implementation of TabProperties class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABPROPERTIES_H
#define TABPROPERTIES_H

#include <header.h>

#include "songkey.h"
#include "tablyrics.h"

/*
	The class TabProperties stores :
		- title
		- sub title
		- artist's name
		- album
		- author
		- copyright
		- transcriber
		- instructions
		- comments
		- tempo
		- shuffle
		- octave
		- lyrics
*/
class TabProperties : public SongKey, public TabLyrics
{
public:
	/*
		Create an empty TabProperties
	*/
	TabProperties();
	
	/*
		The desctructor does nothing.
	*/
	virtual ~TabProperties();
	
	/*
		Set the title.
	*/
	virtual void setTitle(const QString& s);
	
	/*
		Get the title
	*/
	virtual QString title() const;
	
	/*
		Set the sub title.
	*/
	virtual void setSubTitle(const QString& s);
	
	/*
		Get the sub title.
	*/
	virtual QString subTitle() const;
	
	/*
		Set the name of the artist.
	*/
	virtual void setArtist(const QString& s);
	
	/*
		Get the name of the artist.
	*/
	virtual QString artist() const;
	
	/*
		Set the name of the album.
	*/
	virtual void setAlbum(const QString& s);
	
	/*
		Get the name of the album.
	*/
	virtual QString album() const;
	
	/*
		Set the name of the author.
	*/
	virtual void setAuthor(const QString& s);
	
	/*!
		Get the name of the author.
	*/
	virtual QString author() const;
	
	/*
		Set the copyright.
	*/
	virtual void setCopyright(const QString& s);
	
	/*
		Get the copyright.
	*/
	virtual QString copyright() const;
	
	/*
		Set the name of the transcriber.
	*/
	virtual void setTranscriber(const QString& s);
	
	/*
		Get the name of the transcriber.
	*/
	virtual QString transcriber() const;
	
	/*
		Set the instructios.
	*/
	virtual void setInstructions(const QString& s);
	
	/*
		Get the instructions.
	*/
	virtual QString instructions() const;
	
	/*
		Set the comments.
	*/
	virtual void setComments(const QString& s);
	
	/*
		Get the comments.
	*/
	virtual QString comments() const;
	
	/*
		Set the shuffle.
	*/
	virtual void setShuffle(bool i);
	
	/*
		Get the shuffle.
	*/
	virtual bool isShuffle() const;
	
	/*
		Set the tempo.
	*/
	virtual void setTempo(unsigned int i);
	
	/*
		Get the tempo.
	*/
	virtual unsigned int tempo() const;
	
	/*
		Set the octave
	*/
	virtual void setOctave(int i);
	
	/*
		Get the octave
	*/
	virtual int octave() const;
	
private:
	QString titleProp;
	QString subTitleProp;
	QString artistProp;
	QString albumProp;
	QString authorProp;
	QString copyrightProp;
	QString transcriberProp;
	QString instructionsProp;
	QString commentsProp;
	bool shuffle;
	unsigned int tempoProp;
	int octaveProp;
};

#endif
