/***************************************************************************
 * tabsong.cpp: implementation of TabSong class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "tabsong.h"

TabSong::TabSong(QString title, int tempo)
{
	setTempo(tempo);
	setTitle(title);
}

TabSong::TabSong()
{
}

bool TabSong::isDrumTrack()
{
	for (uint i = 0; i < count(); i++)
		if (at(i)->mode() == DrumTab)
		return true;
	
	return false;
}

int TabSong::drumTrack()
{
	for (uint i = 0; i < count(); i++)
		if (at(i)->mode() == DrumTab)
		return i;
	
	return -1;
}
