/***************************************************************************
 * tabtrack.cpp: implementation of TabTrack class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "accidentals.h"
#include "settings.h"
#include "tabtrack.h"

TabTrack::TabTrack()
: tabBar(0)
{
}

TabTrack::TabTrack(TrackMode tm, const QString& name, int channel, int bank, uchar patch, char string, char frets)
: TrackProperties(tm, name, channel, bank, patch, string, frets), tabBar(0)
{
	const uchar standtune[6] = {40, 45, 50, 55, 59, 64};
	
	for (int i = 0; i < string; i++)
		setTune(i, standtune[i]);
}

void TabTrack::setBar(uint i, TabBar &tempBar)
{
	tabBar[i] = tempBar;
}

TabBar TabTrack::bar(uint i) const
{
	return tabBar[i];
}

void TabTrack::addBar(const TabBar &tempBar)
{
	tabBar.push_back(tempBar);
}

void TabTrack::insertBar(uint i, const TabBar &tempBar)
{
	QValueVector<TabBar>::iterator it;
	uint j = 0;
	
	for (it = tabBar.begin(); it != tabBar.end() && j < i; ++it, j++)
		;
	
	if (i == j)
		tabBar.insert(it, tempBar);
	else
		tabBar.push_back(tempBar);
}

void TabTrack::deleteBar(uint i)
{
	QValueVector<TabBar>::iterator it;
	uint j = 0;

	for (it = tabBar.begin(); it != tabBar.end() && j < i; ++it, j++)
		;
	
	if (i == j) tabBar.erase(it);
}

unsigned int TabTrack::count() const
{
	return tabBar.count();
}

void TabTrack::setNbStrings(unsigned char i)
{
	unsigned int j, k, l;
	unsigned char oldStrings = nbStrings();
	
	TrackProperties::setNbStrings(i);
	
	if (i < oldStrings) {
		for (k = 0; k < tabBar.count(); k++) {
			TabBar bar = tabBar[k];
			
			for (l = 0; l < bar.count(); l++) {
				TabTimes times = bar.times(l);
				
				for (j = i + 1; j <= oldStrings; j++) {
					TabNote note = times.notes(j);
					
					note.setEmpty(true);
					
					times.setNotes(j, note);
				}
				
				bar.setTimes(l, times);
			}
			
			tabBar[k] = bar;
		}
	}
}

void TabTrack::setNbFrets(unsigned char i)
{
	TrackProperties::setNbFrets(i);
}

