/***************************************************************************
 * tabtrack.h: implementation of TabTrack class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TABTRACK_H
#define TABTRACK_H

#include <header.h>

#include "tabbar.h"
#include "trackproperties.h"

/*
	The class TabTrack describes a track and it properties.
*/
class TabTrack : public TrackProperties {
public:
	/*
		Create a new track.
	*/
	TabTrack();
	
	/*
		Create a new track.
	*/
	TabTrack(TrackMode tm, const QString& name, int channel, int bank, uchar patch, char string, char frets);
	
	/*
		Set a bar at position i.
	*/
	void setBar(uint i, TabBar& tempBar);
	
	/*
		Return the bar at the popstion i.
	*/
	TabBar bar(uint i) const;
	
	
	/*
		Insert a new bar at the end.
	*/
	void addBar(const TabBar& tempBar);
	
	/*
		Insert a bar at the position i. If this is the end
		a new bar is added, or the bar is inserted in the middle.
	*/
	void insertBar(uint i, const TabBar& tempBar);
	
	/*
		Delete the bar at the position i.
	*/
	void deleteBar(uint i);
	
	/*
		Count the number of bars.
		\return The number of bar.
	*/
	unsigned int count() const;
	
	/*
		Set the strings number.
	*/
	virtual void setNbStrings(unsigned char i);
	
	/*
		Set the frets number.
	*/
	virtual void setNbFrets(unsigned char i);
	
private:
	QValueVector<TabBar> tabBar;
};

#endif
