/***************************************************************************
 * timesignature.h: implementation of TimeSignature class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef _TIMESIGNATURE
#define _TIMESIGNATURE

/*
	The class TimeSignature represents a time signature
	i.e. 3/4 4/4 6/8 ...
*/
class TimeSignature
{
public:
	/*
		Create a class with a 4/4 default signature.
	*/
	TimeSignature();
	
	/*
		Create a time signature class.
	*/
	TimeSignature(unsigned char time1, unsigned char time2);
	
	/*
		Set the time signature.
	*/
	void  setTimeSignature(unsigned char i, unsigned char j);
	
	/*
		Get the time signature.
	*/
	unsigned char timeSignature(unsigned char i) const;
	
	bool operator==(const TimeSignature& timeSignature) const;
	bool operator!=(const TimeSignature& timeSignature) const;
private:
	unsigned char time[2];
};

#endif
