#include "trackmidiproperties.h"

TrackMidiProperties::TrackMidiProperties()
: midiPatch(0), midiChannel(0), midiChannelEffects(0), midiMidiPort(0),
  midiBank(0), midiVolume(16), midiBalance(8), midiChorus(0), midiReverb(0),
  midiPhaser(0), midiTremolo(0)
{
}

TrackMidiProperties::~TrackMidiProperties()
{
}

void TrackMidiProperties::setPatch(unsigned char i)
{
	midiPatch = i;
}

unsigned char TrackMidiProperties::patch() const
{
	return midiPatch;
}

void TrackMidiProperties::setChannel(unsigned char i)
{
	midiChannel = i;
}

unsigned char TrackMidiProperties::channel() const
{
	return midiChannel;
}

void TrackMidiProperties::setChannelEffects(unsigned char i)
{
	midiChannelEffects = i;
}

unsigned char TrackMidiProperties::channelEffects() const
{
	return midiChannelEffects;
}

void TrackMidiProperties::setMidiPort(int i)
{
	midiMidiPort = i;
}

int TrackMidiProperties::midiPort() const
{
	return midiMidiPort;
}

void TrackMidiProperties::setBank(unsigned int i)
{
	midiBank = i;
}

unsigned int TrackMidiProperties::bank() const
{
	return midiBank;
}

void TrackMidiProperties::setVolume(unsigned char i)
{
	midiVolume = i;
}

unsigned char TrackMidiProperties::volume() const
{
	return midiVolume;
}

void TrackMidiProperties::setBalance(char i)
{
	midiBalance = i;
}

char TrackMidiProperties::balance() const
{
	return midiBalance;
}

void TrackMidiProperties::setChorus(unsigned char i)
{
	midiChorus = i;
}

unsigned char TrackMidiProperties::chorus() const
{
	return midiChorus;
}

void TrackMidiProperties::setReverb(unsigned char i)
{
	midiReverb = i;
}

unsigned char TrackMidiProperties::reverb() const
{
	return midiReverb;
}

void TrackMidiProperties::setPhaser(unsigned char i)
{
	midiPhaser = i;
}

unsigned char TrackMidiProperties::phaser() const
{
	return midiPhaser;
}

void TrackMidiProperties::setTremolo(unsigned char i)
{
	midiTremolo = i;
}

unsigned char TrackMidiProperties::tremolo() const
{
	return midiTremolo;
}
