/***************************************************************************
 * trackmidiproperties.h: implementation of TrackMidiProperties class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef _TRACKMIDIPORPERTIES
#define _TRACKMIDIPORPERTIES

/*
	The class TrackMidiProperties describes the midi properties 
	of a track.
*/
class TrackMidiProperties
{
public:
	TrackMidiProperties();
	
	/*
		Does nothing.
	*/
	virtual ~TrackMidiProperties();
	
	virtual void setPatch(unsigned char i);
	virtual unsigned char patch() const;
	
	virtual void setChannel(unsigned char i);
	virtual unsigned char channel() const;
	
	virtual void setChannelEffects(unsigned char i);
	virtual unsigned char channelEffects() const;
	
	virtual void setMidiPort(int i);
	virtual int midiPort() const;
	
	virtual void setBank(unsigned int i);
	virtual unsigned int bank() const;
	
	virtual void setVolume(unsigned char i);
	virtual unsigned char volume() const;
	
	virtual void setBalance(char i);
	virtual char balance() const;
	
	virtual void setChorus(unsigned char i);
	virtual unsigned char chorus() const;
	
	virtual void setReverb(unsigned char i);
	virtual unsigned char reverb() const;
	
	virtual void setPhaser(unsigned char i);
	virtual unsigned char phaser() const;
	
	virtual void setTremolo(unsigned char i);
	virtual unsigned char tremolo() const;
	
private:
	unsigned char midiPatch;
	unsigned char midiChannel;
	unsigned char midiChannelEffects;
	unsigned int midiMidiPort;
	unsigned int midiBank;
	unsigned char midiVolume;
	char midiBalance;
	unsigned char midiChorus;
	unsigned char midiReverb;
	unsigned char midiPhaser;
	unsigned char midiTremolo;
};

#endif
