/***************************************************************************
 * trackproperties.h: implementation of TrackProperties class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef _TRACKPORPERTIES
#define _TRACKPORPERTIES

#include <header.h>

#include "trackmidiproperties.h"
#include "timesignature.h"

/*
	Enum to designate various track modes.
*/
enum TrackMode{
	/*
		Fret mode.
	*/
	FretTab,
	/*
		Drum mode.
	*/
	DrumTab,
	/*
		Twele strings guitar.
	*/
	TwelveStringsTab,
	/*
		Banjo.
	*/
	BanjoTab
};

/*
	The class TrackProperties decribes the properties of a track :
		- mode
		- name
		- midi
		- time signature
		- tune
		- number of strings
		- number of frets
*/
class TrackProperties : public TrackMidiProperties, public TimeSignature
{
public:
	/*
		Create a new TrackProperties.
	*/
	TrackProperties();
	
	/*
		Create a new TrackProperties.
	*/
	TrackProperties(TrackMode mode, const QString& name, uchar channel, unsigned int bank, uchar patch, uchar strings, uchar frets);
	
	/*
		Does nothing.
	*/
	virtual ~TrackProperties();
	
	/*
		Set the mode of the track.
	*/
	virtual void setMode(TrackMode mode);
	
	/*
		Get the mode of the track.
	*/
	virtual TrackMode mode() const;
	
	/*
		Set the name of the track.
	*/
	virtual void setName(const QString &string);
	
	/*
		Get the name of the track.
	*/
	virtual QString name() const;
	
	/*
		Set the color of the bar.
	*/
	virtual void setColor(const QColor& c);
	
	/*
		Get the color of the bar.
	*/
	virtual QColor color() const;
	
	/*
		Set the number of strings.
	*/
	virtual void setNbStrings(uchar i);
	
	/*
		Get the number of strings.
	*/
	virtual unsigned char nbStrings() const;
	
	/*
		Set the number of frets.
	*/
	virtual void setNbFrets(uchar i);
	
	/*
		Get the number of frets.
	*/
	virtual unsigned char nbFrets() const;
	
	/*
		Set the tuning of the track j is the fret and i is the chord.
	*/
	virtual void setTune(uchar i, uchar j);
	
	/*
		Get the tuning of the track i is the chord.
	*/
	virtual uchar tune(uchar i) const;
	
	/*
		Set the capo.
	*/
	virtual void setCapo(uchar c);
	
	/*
		Get the capo.
	*/
	virtual uchar capo() const;
	
	
private:
	TrackMode trackMode;
	QString nameProp;
	QColor colorTrack;
	unsigned char nbStringsProp;
	unsigned char nbFretsProp;
	unsigned char capoFret;
	QValueVector<unsigned char> tuneProp;
};

#endif
