#ifndef TABSONGPLAY_H
#define TABSONGPLAY_H

#include <header.h>

#include "tabsong.h"

class PlaybackTracker;

// This class is used to play a time within a thread
//
class TabSongPlayer : public TabSong, public QThread
{
public:
	TabSongPlayer(const TabSong& tempSong, PlaybackTracker* tracker);
	
	void setScheduler(TSE3::MidiScheduler* midiScheduler);
	void stopPlaying();
	
protected:
	void run();
	
private:
	inline long calcDuration(const TabTimes& times) const;
	inline long calcLink(uint barNb, uint timeNb, uint chord, const TabTrack& tempTrack) const;
	inline bool checkLinkAndRest(uint barNb, uint timeNb, uint chord, const TabTrack& tempTrack) const;
	
	TSE3::MidiScheduler* scheduler;
	PlaybackTracker* playbackTracker;
	bool stop;
};

#endif
