#ifndef TABTIMESPLAY_H
#define TABTIMESPLAY_H

#include <header.h>

#include "tabtimes.h"

class TabTrack;

// This class is used to play a time within a thread
//
class TabTimesPlayer : public TabTimes, public QThread
{
public:
	TabTimesPlayer(const TabTimes& tempTimes, uint tempo);
	
	void drum();
	void setScheduler(TSE3::MidiScheduler* midiScheduler);
	void setTrack(const TabTrack* currentTrack);
	
	void stopPlaying();
	
protected:
	void run();
	
private:
	TSE3::MidiScheduler* scheduler;
	const TabTrack* track;
	bool stop;
	uint channel;
	uint tempo;
};

#endif
