#include "trackbarlineview.h"

TrackBarLineView::TrackBarLineView(uint strings, uint height, int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  nbStrings(strings),
  lineSpaces(height),
  canvasView(canvas),
  line(0)
{
}

void TrackBarLineView::draw(const QPoint& position, uint barWidth)
{
	line = new QCanvasLine*[nbStrings + 2];
	
	for (uint i = 0; i < nbStrings + 2; i++)
		line[i] = new QCanvasLine(canvasView);
	
	line[0]->setPoints(position.x(), position.y(), position.x(), position.y() + (nbStrings - 1) * lineSpaces);
	line[1]->setPoints(position.x() + barWidth - 1, position.y(), position.x() + barWidth - 1, position.y() + (nbStrings - 1) * lineSpaces);
	
	line[0]->show();
	line[1]->show();
	
	// horizontal lines from position.x() to position.x()+w-1
	//
	for (uint i = 0; i < nbStrings; i++) {
		line[i + 2]->setPoints(position.x(), position.y() + i * lineSpaces, position.x() + barWidth - 1, position.y() + i * lineSpaces);
		line[i + 2]->show();
	}
}

TrackBarLineView::~TrackBarLineView()
{
	if (!line)
		return ;
	
	for (uint i = 0; i < nbStrings + 2; i++) {
		line[i]->hide();
		
		delete line[i];
	}
	
	delete line;
}
