/***************************************************************************
 * trackcursorview.h: implementation of TrackCursorView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKCURSORVIEW_H
#define TRACKCURSORVIEW_H

#include <header.h>

#include "trackpos.h"

class TrackCursorView
{
public:
	TrackCursorView(QCanvas* canvas);
	virtual ~TrackCursorView();
	
	void setVisible(bool yes);
	
	// Refresh the view
	//
	void refresh(const QPoint& position);
	
	// Return the position of the cursor
	//
	QPoint position() const
	{ return QPoint(rectangle.rect().x(), rectangle.rect().y()); }
private:
	QCanvas* canvasView;
	QCanvasRectangle rectangle;
};

#endif
