/***************************************************************************
 * trackdrag.cpp: implementation of TrackDrag class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "tabtrack.h"
#include "trackdrag.h"

TrackDrag::TrackDrag(TabTrack& tabTrack, QWidget *dragSource, const char *name)
: QStoredDrag("application/x-kguitar-snippet", dragSource, name)
{
	setTrack(tabTrack);
}


TrackDrag::TrackDrag(QWidget *dragSource, const char *name)
: QStoredDrag("application/x-kguitar-snippet", dragSource, name)
{
}

TrackDrag::~TrackDrag()
{
}

void TrackDrag::setTrack(TabTrack& tabTrack)
{
/*	// Save to buffer
	//
	QBuffer buffer;
	buffer.open(IO_WriteOnly);
	QDataStream stream(&buffer);
	TabBar bar;
	TabTimes times;
	
	// TrackProperties
	//
	stream << static_cast<uint>(tabTrack.getMode());
	stream << tabTrack.getName();
	stream << tabTrack.getChannel();
	stream << tabTrack.getBank();
	stream << tabTrack.getPatch();
	stream << tabTrack.getNbStrings();
	stream << tabTrack.getNbFrets();
	for (int i = 0; i < tabTrack.getNbStrings(); i++)
		stream << tabTrack.getTune(i);
	
	for (uint j = 0; j < tabTrack.countBar(); j++) {
		stream << QString("<Bar/>");
		
		bar = tabTrack.getBar(j);
		
		stream << bar.getTimeSignature(0);
		stream << bar.getTimeSignature(1);
		stream << bar.getKeySignature();
		
		for (uint k = 0; k < bar.getLength(); k++) {
			stream << QString("<Times/>");
			
			times = bar.getTimes(k);
			
			stream << static_cast<uint>(times.getRest());
			
			if (times.getRest() == true) {
				stream << times.getDuration();
			} else {
				stream << times.getDuration();
				
				for (uint l = 0; l < times.getSize(); l++) {
					stream << times.getNotes(l).fret();
				}
				
				for (uint l = 0; l < times.getSize(); l++){
					if (times.getEffectBend(l) != NoneBend) {
						stream << "bend";
						stream << static_cast<uint>(times.getEffectBend(l));
						stream << l ;
					} if (times.getEffectVibrato(l) != NoneVibrato) {
						stream << "vibrato";
						stream << static_cast<uint>(times.getEffectVibrato(l));
						stream << l ;
					} if (times.getEffectHarmonic(l) != NoneHarmonic) {
						stream << "harmonic";
						stream << static_cast<uint>(times.getEffectHarmonic(l));
						stream << l ;
					} if (times.getEffectRing(l) != NoneRing) {
						stream << "ring";
						stream << static_cast<uint>(times.getEffectRing(l));
						stream << l ;
					} if (times.getEffectOthers(l) != NoneOthers) {
						stream << "others";
						stream << static_cast<uint>(times.getEffectOthers(l));
						stream << l ;
					}
				}
			}
			
		}
	}
	
	buffer.close();
	
	setEncodedData(buffer.buffer());*/
}

bool TrackDrag::canDecode(const QMimeSource& mimeSource)
{
	return mimeSource.provides("application/x-kguitar-snippet");
}

bool TrackDrag::decode(const QMimeSource& mimeSource, TabTrack& tabTrack)
{
/*	QByteArray byte;
	QBuffer buffer;
	QString temp;
	
	QString trackName;
	uchar trackTune;
	uint trackMode, trackBank;
	uchar trackChannel, trackPatch, trackNbStrings, trackNbFrets;
	
	uchar barTimeSignature[2];
	short barKeySignature;
	
	uint timesRest;
	bool timesEffect;
	uint timesDuration;
	uint timesKindEffect;
	uint timesFret;
	uchar timesNotes;
	
	if (!canDecode(mimeSource)) {
		kdDebug() << "TrackDrag::decode(...) >> can't decode QMimeSource!!" << endl;
		return false;
	}
	
	byte = mimeSource.encodedData("application/x-kguitar-snippet");
	if (byte.size() == 0) {
		kdDebug() << "No data in the clipboard" << "\n";
		return false;
	}
	
	buffer.setBuffer(byte);
	buffer.open(IO_ReadOnly);
	
	QDataStream stream(&buffer);
	
	// TrackProperties
	//
	stream >> trackMode;
	tabTrack.setMode(static_cast<TrackMode>(trackMode));
	stream >> trackName;
	tabTrack.setName(trackName);
	stream >> trackChannel;
	tabTrack.setChannel(trackChannel);
	stream >> trackBank;
	tabTrack.setBank(trackBank);
	stream >> trackPatch;
	tabTrack.setPatch(trackPatch);
	stream >> trackNbStrings;
	tabTrack.setNbStrings(trackNbStrings);
	stream >> trackNbFrets;
	tabTrack.setNbFrets(trackNbFrets);
	for (uchar i = 0; i < trackNbStrings; i++) {
		stream >> trackTune;
		tabTrack.setTune(i, trackTune);
	}
	
	stream >> temp;
	while ((stream.atEnd() == false) && (temp == "<Bar/>")) {
		stream >> barTimeSignature[0];
		stream >> barTimeSignature[1];
		stream >> barKeySignature;
		
		TabBar tempBar(barTimeSignature[0], barTimeSignature[1], trackNbStrings, trackNbFrets);
		
		stream >> temp;
		while ((stream.atEnd() == false) && (temp == "<Times/>")) {
			TabTimes times(trackNbStrings, trackNbFrets);
			
			stream >> timesRest;
			
			stream >> timesDuration;
			
			times.setDuration(timesDuration);
			times.setRest(timesRest);
			if (timesRest == false) {
				for (uint i = 0; i < trackNbStrings; i++) {
					stream >> timesNotes;
					TabNote note;
					note.setFret(timesNotes);
					times.setNotes(i, note);
				}
				
				timesEffect = true;
				
				if (stream.atEnd() == false)
					stream >> temp;
				else {
					timesEffect = false;
					temp = "";
				}
				
				while (timesEffect) {
					if (temp == "bend") {
						stream >> timesKindEffect;
						stream >> timesFret;
						times.setEffect(timesFret, static_cast<effectBend>(timesKindEffect));
					} else
					if (temp == "vibrato") {
						stream >> timesKindEffect;
						stream >> timesFret;
						times.setEffect(timesFret, static_cast<effectVibrato>(timesKindEffect));
					} else
					if (temp == "harmonic") {
						stream >> timesKindEffect;
						stream >> timesFret;
						times.setEffect(timesFret, static_cast<effectHarmonic>(timesKindEffect));
					} else
					if (temp == "ring") {
						stream >> timesKindEffect;
						stream >> timesFret;
						times.setEffect(timesFret, static_cast<effectRing>(timesKindEffect));
					} else
					if (temp == "others") {
						stream >> timesKindEffect;
						stream >> timesFret;
						times.setEffect(timesFret, static_cast<effectOthers>(timesKindEffect));
					} else {
						timesEffect = false;
					}
				}
			} else {
				if (stream.atEnd() == false)
					stream >> temp;
				else
					temp = "";
			}
			
			tempBar.insertTimes(times);
		}
		tabTrack.addBar(tempBar);
	}
	
	buffer.close();*/
	
	return true;
}
