/***************************************************************************
 * trackveditiew.h: implementation of TrackEditView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKEDITVIEW_H
#define TRACKEDITVIEW_H

#include <header.h>

#include "tabduration.h"
#include "trackpos.h"
#include "trackview.h"

class Fretboard;
class TabBar;
class TabSong;
class TabTimes;
class TabTimesPlayer;
class TabTrack;
class TrackBarView;
class TrackCursorView;
class TrackPane;
class TrackPos;
class TrackPageView;
class TrackPrint;
class TrackTitleView;
class TrackTuningView;
class TrackWordsAndMusicView;

//! In this class you can edit tablature, draw tablature. add effects, add bars, ...
/*!
	There are importants vars in this class :
		- TabSong* song  : represent the tablature.
		- TabTrack* curt : this is an ugly name I will change that and representent the current track.
		- TrackPrint* trp : ugly name this object draw the current track.
		- FretBoard* fret : this object draw the fret board and also ??? enable a fast edit mode ??? but I think I had disabled this feature ????
		- uchar curPos, curBarPos, curNotePos : store the position of the current bar, current note in the bar, and current chord in the object curt
		TODO: change uchar with TrackPos.
		- TrackPos relativePos : store the position of the cursor the position is not the same as curPos, curBarPos, curNotePos I will explain latter.
		- QValueList<uint> begin : store the number of track which is the beginning of a line I will explain latter :p.
*/
class TrackEditView : public QCanvasView {
	Q_OBJECT
public:
	/*!
		Constructor, init some constants, set the number of columns, set the size of a row and a column,
		also init the fonts.
		\param midiScheduler the midi scheduler
		\param s the tablature
		\param _XMLGUIClient I don't what is the use of this var ???
		\param _cmdHist store the history for the edition, do the undo-redo capabilites
		\param parent the parent of this widget
		\param name name of the widget (usefull for debugging ???)
	*/
	TrackEditView(QCanvas* canvas, TSE3::MidiScheduler* midiScheduler, TabSong *s, KXMLGUIClient *_XMLGUIClient, KCommandHistory *_cmdHist, QWidget *parent = 0, const char *name = 0);
	
	/*!
		Destructor, free the memory.
	*/
	virtual ~TrackEditView();
	
	/*!
		Return the current track. Used if the tab has multiple tracks.
		\return curt the current track.
	*/
	TabTrack* getTrack() const { return currentTrack; }
	
	/*!
		Set the current track. Used if the tab has multiple tracks.
		\param trk The new current track.
	*/
	void setCurrentTrack(TabTrack *trk);
	
	/*
		Change the cursor position and refresh the view
	*/
	void setCursor(const TrackPos& position);
	
	/*
		This function send a drawing event and redraw
		all the bars in the current track.
	*/
	void drawAllTrack();
	
	/*
		Inits the auto update of the canvas
	*/
	void beginPlaying();
	
	/*
		Disable the auto update of the canvas and
		stop playing a time (if it plays a time)
	*/
	void stopPlaying();
	
	void setTrackPane(TrackPane* pane);
	
	// Forwards declarations of all undo/redo commands
	//
	class SetLengthCommand;
	class InsertTabCommand;
	class MoveFingerCommand;
	class AddFXCommand;
	class SetFlagCommand;
	class InsertNoteCommand;
	class DeleteNoteCommand;
	class AddColumnCommand;
	class DeleteColumnCommand;
	class SetTimeSigCommand;
	class InsertColumnCommand;
	class InsertStrumCommand;
	class InsertRhythm;
	class NTupletCommand;
	
	class DeadNoteCommand;
	class RestNoteCommand;
	class DottedNoteCommand;
	class BendNoteCommand;
public slots:
	/*!
		Insert an half bend effect.
	*/
	void halfBend();
	
	/*!
		Insert an full bend effect.
	*/
	void fullBend();
	
	/*!
		Insert an half bend and release effect.
	*/
	void halfBendRelease();
	
	/*!
		Insert an full bend and release effect.
	*/
	void fullBendRelease();
	
	/*!
		Insert an half pre bend effect.
	*/
	void halfPreBend();
	
	/*!
		Insert an full pre bend effect.
	*/
	void fullPreBend();
	
	/*!
		Insert an half pre bend and release effect.
	*/
	void halfPreBendRelease();
	
	/*!
		Insert an full pre bend and release effect.
	*/
	void fullPreBendRelease();
	
	/*!
		Insert an unison bend effect.
	*/
	void unisonBend();
	
	/*!
		Insert a vibrator effect.
	*/
	void vibrato();
	
	/*!
		Insert a wide vibrato effect.
	*/
	void wideVibrato();
	
	/*!
		Insert a trill effect.
	*/
	void trill();
	
	/*!
		Insert a tapping effect.
	*/
	void tapping();
	
	/*!
		Insert a tremolo bar effect.
	*/
	void tremoloBar();
	
	/*!
		Insert a muffled strings effect.
	*/
	void muffledStrings();
	
	/*!
		Insert a pick slide effect.
	*/
	void pickSlide();
	
	/*!
		Insert a tremolo picking effect.
	*/
	void tremoloPicking();
	
	/*!
		Set the length of a note.
	*/
	void setLength1() { setLength(Whole); };
	
	/*!
		Set the length of a note.
	*/
	void setLength2() { setLength(Half); };
	
	/*!
		Set the length of a note.
	*/
	void setLength4() { setLength(Quarter); };
	
	/*!
		Set the length of a note.
	*/
	void setLength8() { setLength(Eighth); };
	
	/*!
		Set the length of a note.
	*/
	void setLength16() { setLength(Sixteenth); };
	
	/*!
		Set the length of a note.
	*/
	void setLength32() { setLength(ThirthSecond); };
	
	/*!
		Set or unset a dotted note.
	*/
	void setDotted();
	
	/*!
		Set or unset a rest.
	*/
	void setRest();
	
	/*!
		Set the key signature.
	*/
	void keySig();
	
	/*!
		Set the time signature.
	*/
	void timeSig();
	
	/*!
		Insert a link previous effect.
	*/
	void linkPrev();
	
	/*!
		Insert a natural harmonic effect.
	*/
	void addHarmonic();
	
	/*!
		Insert an artificial harmonic effect.
	*/
	void addArtHarm();
	
	/*!
		Insert a legato effect.
	*/
	void addLegato();
	
	/*!
		Insert a slide effect.
	*/
	void addSlide();
	
	/*!
		Insert a let ring effect.
	*/
	void addLetRing();
	
	/*!
		Insert a chord effect.
	*/
	void insertChord();
	
	/*!
		Insert a rythmer effect.
	*/
	void rhythmer();
	
	/*!
		move the cursor to the left.
	*/
	void keyLeft();
	
	/*!
		move the cursor to the right.
	*/
	void keyRight();
	
	/*!
		move the cursor at the begining.
	*/
	void keyHome();
	
	/*!
		move the cursor at the end.
	*/
	void keyEnd();
	
	/*!
		move the cursor to the right.
	*/
	void keyCtrlHome();
	
	/*!
		move the cursor to the right.
	*/
	void keyCtrlEnd();
	
	/*!
		move the cursor to an high string.
	*/
	void moveUp();
	
	/*!
		move the cursor to an low string.
	*/
	void moveDown();
	
	/*!
		move the cursor to an high string.
	*/
	void transposeUp();
	
	/*!
		move the cursor to an high string.
	*/
	void transposeDown();
	
	/*!
		move the cursor to an high string.
	*/
	void selectLeft();
	
	/*!
		move the cursor to an high string.
	*/
	void selectRight();
	
	/*!
		move the cursor to an high string.
	*/
	void deadNote();
	
	/*!
		Delete the current note.
	*/
	void deleteNote();
	
	/*!
		Delete the current column.
	*/
	void deleteColumn();
	
	/*!
		move the cursor to an high string.
	*/
	void deleteColumn(QString name);
	
	/*!
		Insert a column.
	*/
	void insertColumn();
	
	/*!
		Insert a bar.
	*/
	void insertBar();
	
	/*!
		Insert a palm mute effect.
	*/
	void palmMute();
	
	/*!
		Insert a dot note effect.
	*/
	void dotNote();
	
	/*!
		Select a n-tuplet number.
	*/
	void ntupletSelected(int n);
	
	/*!
		Insert a n-tuplet effect.
	*/
	void ntuplet();
	
	/*!
		Set the length of a note.
	*/
	void keyPlus();
	
	/*!
		Set the length of a note.
	*/
	void keyMinus();
	
	/*!
		Set the length of a note.
	*/
	void arrangeTracks();
	
	/*!
		Edit one note.
	*/
	void key1() { insertTab(1); }
	
	/*!
		Edit one note.
	*/
	void key2() { insertTab(2); }
	
	/*!
		Edit one note.
	*/
	void key3() { insertTab(3); }
	
	/*!
		Edit one note.
	*/
	void key4() { insertTab(4); }
	
	/*!
		Edit one note.
	*/
	void key5() { insertTab(5); }
	
	/*!
		Edit one note.
	*/
	void key6() { insertTab(6); }
	
	/*!
		Edit one note.
	*/
	void key7() { insertTab(7); }
	
	/*!
		Edit one note.
	*/
	void key8() { insertTab(8); }
	
	/*!
		Edit one note.
	*/
	void key9() { insertTab(9); }
	
	/*!
		Edit one note.
	*/
	void key0() { insertTab(0); }
	
	/*!
		Actions of the melody editor
	*/
	void melodyEditorPress(int, int, ButtonState);
	/*!
		I DON'T KNOW
	*/
	void melodyEditorRelease(ButtonState);
	
	/*!
		Change the track and refresh the view.
		\param trk the new track to display.
	*/
	void selectTrack(TabTrack *trk);
	
	/*!
		I DON'T KNOW
	*/
	void setPlaybackCursor(bool);
	
	/*!
		I DON'T KNOW
	*/
	void viewScore(bool);
	
	/*!
		Number of bar.
		\return return the number of bar.
	*/
	uint getBarNumber();
	
	/*!
		Bar the number where the cursor is.
		\return return the position of the cursor.
	*/
	uint getBarPosition();
	
	/*
		Set the string position of the cursor this function
		is used by songviewcommand when the user change the number
		of strings
	*/
	void setString(uint i);
	
	/*
		Return the string position of the cursor this function
		is used by songviewcommand when the user change the number
		of strings
	*/
	uint string();
	
signals:
	/*!
		Signal emitted when the song is changed
	*/
	void songChanged(bool);
	
	/*!
		Signal emitted when the user moves the cursor
		or changed the song.
	*/
	void timesChanged(const TabTimes&);
	
	/*!
		Display a message on the status bar.
		\param msg the message displayed.
	*/
	void statusBar(const QString& msg);
	
	/*!
		I DON'T KNOW
	*/
	void paneChanged();
	
	/*!
		I DON'T KNOW
	*/
	void trackChanged(TabTrack *);
	
	/*!
		I DON'T KNOW
	*/
	void columnChanged();
	
	/*!
		Stop the midi playing because a note or a chord is inserted 
	*/
	void stopMidiPlaying();
	
private:
	/*!
		Repaint the current column, in fact for the moment redraw the entirely screen.
	*/
	void repaintCell();
	
	/*!
		Called when the user update the size of the app. It refreshs the view.
		\param e the new size of the widget?
	*/
	virtual void resizeEvent(QResizeEvent *);
	
	/*!
		Go to the nth bar and nth times in the current track
		or display a popup menu
	*/
	virtual void contentsMousePressEvent(QMouseEvent *);
	
	/*!
		Calcul the size of a bar.
		\param tabBar the current bar.
		\return size the size of the bar.
	*/
	uint barSize(const TabBar&);
	
	/*!
		I DON'T KNOW
	*/
	void setLength(Duration l);
	
	/*!
		I DON'T KNOW
	*/
	void insertTab(int num);
	
	/*!
		I DON'T KNOW
	*/
	void melodyEditorAction(int num, int fret, int action);
	
	/*!
		Move the cursor to the left and refresh the view.
		Go to the previous note, or bar.
	*/
	void moveLeft();
	
	/*!
		Move the cursor to the right and refresh the view.
		May add an new note, add a new bar, or simply go to
		the next bar, or next note.
	*/
	void moveRight();
	
	/*!
		Move to the first note in the first bar.
	*/
	void moveHome();
	
	/*!
		Move to the last note in the last bar
	*/
	void moveEnd();
	
	/*!
		DON'T WORK ???
	*/
	void moveCtrlHome();
	
	/*!
		DON'T WORK ???
	*/
	void moveCtrlEnd();

	/*!
		Display the current on the fretboard
	*/
	void currentTime();
	
	TabSong* tabSong;
	TabTrack* currentTrack;
	Fretboard* fretboard;
	KXMLGUIClient* xmlGUIClient;
	KCommandHistory* cmdHist;
	
	bool playbackCursor;
	int selxcoord;
	bool viewscore;
	
	// The track is modified
	//
	bool change;
	
	//Size of the widget
	//
	QSize size;
	
	TrackPos cursorPos;			// Absolute position of the cursor
	
	uint widthBar;			// Width of the bars
	uint colPos;			// Column number
	
	uint tuplet;
	
	TSE3::MidiScheduler* scheduler;
	TabTimesPlayer* notePlayer;
	
	TrackPane* trackPane;
	
	TrackView* trackView;

	// Space between the first note and the title
	//
	int space;
	
	// The resolution of the view
	//
	int dpi;
};

#endif
