/***************************************************************************
 * tracklist.cpp: implementation of TrackList class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "global.h"
#include "tabsong.h"
#include "tracklist.h"

TrackList::TrackList(TabSong *song, KXMLGUIClient *xml, QWidget *parent, const char *name)
: QListView(parent, name), tabSong(song), xmlGUIClient(xml)
{
	setFocusPolicy(QWidget::StrongFocus);
	setAllColumnsShowFocus(TRUE);
	
	addColumn("N");
	addColumn(i18n("Title"));
	addColumn(i18n("Chn"));
	addColumn(i18n("Bank"));
	addColumn(i18n("Patch"));
	
	updateList();
	
	connect(this, SIGNAL(selectionChanged(QListViewItem *)), SLOT(selectNewTrack(QListViewItem *)));
	
	show();
}

TrackList::~TrackList()
{
}

void TrackList::updateList()
{
	clear();
	
	QListIterator<TabTrack> it(*tabSong);
	for (int n = 1; it.current(); ++it) {		// For every track
		TabTrack *trk = it.current();
		
		(void) new QListViewItem(this, QString::number(n), trk->name(),
								 QString::number(trk->channel()),
								 QString::number(trk->bank()),
								 instruments.getInstrument(trk->patch()));
		n++;
	}

// 	setMaximumHeight(header()->height() + viewport()->height());
}

void TrackList::contentsMousePressEvent(QMouseEvent *e)
{
	QListView::contentsMousePressEvent(e);
	
	if (e->button() == RightButton) {
		QWidget *tmpWidget = 0;
		tmpWidget = xmlGUIClient->factory()->container("tracklistpopup", xmlGUIClient);
		
		if (!tmpWidget || !tmpWidget->inherits("KPopupMenu")) {
			kdDebug() << "TrackList::contentsMousePressEvent => wrong container widget" << endl;
			return;
		}
		
		KPopupMenu *menu(static_cast<KPopupMenu*>(tmpWidget));
		menu->popup(QCursor::pos());
	}
	
	setSelected(currentItem(), TRUE);
}

void TrackList::selectNewTrack(QListViewItem *item)
{
	if (!item)
		return;
	
	int num = item->text(0).toInt() - 1;
	emit trackChanged(tabSong->at(num));
}
