#include "settings.h"
#include "trackpageview.h"

TrackPageView::TrackPageView(uint p, const QRect& size, int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  canvasRectangle(size, canvas),
  pageSize(size),
  page(p),
  textFont(Settings::textAndTabFont(), Settings::textAndTabSize(), Settings::textAndTabWeight(), 
           Settings::textAndTabItalic()),
  textFontInfo(textFont),
  textWidth(textFontInfo.boundingRect("8").width()),
  textHeight(textFontInfo.boundingRect("8").height()),
  textCanvas(canvas)
{
	QString temp;
	const QString textPage("Page " + temp.setNum(p));
	
	textCanvas.setFont(textFont);
	textCanvas.setText(textPage);
	textCanvas.move(size.right() - (textPage.length() + 1) * textWidth, size.bottom() + 0.5 * textHeight);
	
	textCanvas.show();
	canvasRectangle.show();
}
