#include "tracktimesignatureview.h"

TrackTimeSignatureView::TrackTimeSignatureView(const TimeSignature& signature, const QFont& font, int height, int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  timeSignature(signature),
  timeFont(font),
  timeHeight(height)
{
	QString temp;
	
	for (uint i = 0; i < 2; i++)
		canvasView[i] = new QCanvasText(temp.setNum(timeSignature.timeSignature(i)), font, canvas);
}

TrackTimeSignatureView::~TrackTimeSignatureView()
{
	for (uint i = 0; i < 2; i++)
		delete canvasView[i];
}

void TrackTimeSignatureView::draw(QPoint position)
{
	canvasView[0]->move(position.x(), position.y());
	canvasView[0]->show();
	
	canvasView[1]->move(position.x(), position.y() + timeHeight / 2);
	canvasView[1]->show();
}

double TrackTimeSignatureView::width() const
{
	QFontMetrics fm(timeFont);
	QString temp;
	
	return (fm.boundingRect(temp.setNum(timeSignature.timeSignature(0))).width() < fm.boundingRect(temp.setNum(timeSignature.timeSignature(1))).width() ? 
			convertDPIPixel<double>(fm.boundingRect(temp.setNum(timeSignature.timeSignature(1))).width(), 75) :
			convertDPIPixel<double>(fm.boundingRect(temp.setNum(timeSignature.timeSignature(0))).width(), 75));
}

uint TrackTimeSignatureView::height() const
{
	return 0;
}
