/***************************************************************************
 * trackview.h: implementation of TrackView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKVIEW_H
#define TRACKVIEW_H

#include <header.h>

#include "tabduration.h"
#include "trackpos.h"
#include "unit.h"

class Fretboard;
class TabBar;
class TabSong;
class TabTimes;
class TabTimesPlayer;
class TabTrack;
class TrackBarView;
class TrackCursorView;
class TrackPane;
class TrackPos;
class TrackPageView;
class TrackPrint;
class TrackTitleView;
class TrackTuningView;
class TrackWordsAndMusicView;

class TrackView : public Unit {
public:
	TrackView(QCanvas* canvas, const TabSong *song, int resolutionDPI, double left, double bottom, const QSize& displayResolution, bool landscapeView);
	
	/*!
		Destructor, free the memory.
	*/
	virtual ~TrackView();
	
	/*!
		Set the current track. Used if the tab has multiple tracks.
		\param trk The new current track.
	*/
	void setCurrentTrack(const TabTrack *trk);
	
	void refreshCursor(const TrackPos& cursorPos);
	
	QPoint cursorPosition() const;
	
	uint pages() const
	{ return nbPages; }
	
	void setDrawEffects(bool b)
	{ drawEffects = b; }
	
	bool isDrawEffects() const
	{ return drawEffects; }
	
	TrackPos mousePressEvent(const QPoint &position);
private:
	void drawPages(uint nbPages);
	void drawSystem(QPtrList<TrackBarView>& barList, uint newWidth, uint height);
	
	void refreshProperties();
	void refreshView(uint from);
	
	QCanvas* canvasView;
	const TabSong* tabSong;
	const TabTrack* currentTrack;
	
	// Resolution of the track without the margins
	//
	const QSize trackResolution;
	
	bool landscape;
	
	// Margins
	//
	const int leftMargins, bottomMargins;
	
	// Resolution of the track with the margins
	//
	QRect trackBody;
	
	// Position of the tablature on the screen
	//
	QPoint trackPos;
	
	TrackTitleView* titleView;
	TrackWordsAndMusicView* wordsAndMusicView;
	TrackTuningView* tuningView;
	
	// List all of the pages in the current track
	//
	QPtrList<TrackPageView> pageViewList;
	
	// List all of the bars in the current track
	//
	QPtrList<TrackBarView> barViewList;
	
	TrackCursorView* cursorView;
	
	// Number of pages
	//
	uint nbPages;
	
	bool drawEffects;
};

#endif
