#include "settings.h"
#include "tabsong.h"
#include "trackwordsmusicview.h"

TrackWordsAndMusicView::TrackWordsAndMusicView(const TabSong& song, const QRect& size, int resolutionDPI, QCanvas* canvas)
: Unit(resolutionDPI),
  canvasText(canvas),
  pageSize(size),
  tabSong(song)
{
	// Font used for the sub title : the size of the font is 0.350 mm
	// or 0.1378 in and the size is converted in px
	//
	QFont fontSubTitle(Settings::subTitleFont(), Settings::subTitleSize(), Settings::subTitleWeight(), Settings::subTitleItalic());
	
	// Get the height of the font to get the spaces 
	// between the lines.
	//
	QFontMetrics fm(fontSubTitle);
	
	// Make the text
	//
	QString text;
	
	if (tabSong.author() == tabSong.author())
		text = "Words and Music by " + tabSong.author();
	else
		text = "Words by " + tabSong.author() + " and Music by " + tabSong.author();
	
	// Center the text
	//
	const int width = convertDPIPixel(fm.boundingRect(text).width(), 75);
	const int height = convertDPIPixel(fm.boundingRect(text).height(), 75);
	const int x = size.left() + ((size.width() - width) / 2);
	const int y = size.top() + height;
	
	canvasText.setText(text);
	canvasText.setFont(fontSubTitle);
	canvasText.move(x, y);
	canvasText.show();
	
	rectSize.setRect(x, size.top(), width, height);
}
