/***************************************************************************
 * trackwordsmusicview.h: implementation of TrackWordsAndMusicView class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef TRACKWORDVIEW_H
#define TRACKWORDVIEW_H

#include <header.h>

#include "unit.h"

class TabSong;

class TrackWordsAndMusicView : public Unit
{
public:
	TrackWordsAndMusicView(const TabSong& song, const QRect& size, int resolutionDPI, QCanvas* canvas);
	
	/*
		Return the points where the title is draw.
	*/
	inline QRect size() const
	{ return rectSize; }
	
private:
	QCanvasText canvasText;
	QRect pageSize;
	const TabSong& tabSong;
	QRect rectSize;
};

#endif
