#ifndef KGUITAR_H
#define KGUITAR_H

#include <kparts/mainwindow.h>

#include <qprocess.h>

class KRecentFilesAction;
class KToggleAction;
class KAction;
class KActionCollection;
class KCommandHistory;

//! This is the KGuitar application "Shell".
/*!
	It has a menubar, toolbar, and statusbar but relies on the "Part" to 
	do all the real work.
	@short KGuitar Application Shell
*/
class KGuitar: public KParts::MainWindow {
    Q_OBJECT    
public:
	/*!
		Set up specific action and load the kguitar part
	*/
	KGuitar();
	virtual ~KGuitar();
	
public slots:
	void saveURL(const KURL& url);
	void load(const KURL& url);
	
private slots:
	/*
		Quit ktabedit
	*/
	void quit();
	void fileNew();
	void fileOpen();
	void slotToggleMainTB();
	void slotToggleEditTB();
	void optionsShowStatusbar();
	void optionsConfigureKeys();
	void optionsConfigureToolbars();
	
protected:
	virtual void readOptions(KConfig*);
	virtual void saveOptions(KConfig*);
	
private:
	
	void setupActions();
	bool queryClose();
	
	KParts::ReadWritePart *kgpart;
	KRecentFilesAction *openRecentAct;
	KToggleAction *showMainTBAct, *showEditTBAct, *showStatusbarAct;
	KCommandHistory *cmdHistory;
	
	bool display;
};

#endif
