#include "kguitar.h"
#include "config.h"

#include <qdir.h>

#include <kaboutdata.h>
#include <kapp.h>
#include <kcmdlineargs.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <ksplashscreen.h>
#include <kstandarddirs.h>
#include <ktip.h>

static KCmdLineOptions options[] = {
	{ "+[URL]", I18N_NOOP("Document to open."), 0 },
	KCmdLineLastOption
};

static const char *DESCRIPTION = I18N_NOOP("A stringed instrument tabulature editor (with MIDI support)");

int main(int argc, char **argv)
{
	KAboutData about("ktabedit", "KTabEdit", VERSION, DESCRIPTION, KAboutData::License_GPL,
						"(C) 2004-2005 by KTabEdit Development Team", 0,
						"http://ktabedit.sourceforge.net");
	
	about.addAuthor("Gwenael Casaccio", I18N_NOOP("Maintainer and main coder"), "mrgwen@gmail.com");
	about.addCredit("KGuitar team", "http://kguitar.sourceforge.net");
	
	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions(options);
	
	KApplication app;
	KConfig* config;
	
	// see if we are starting with session management
	//
	if (app.isRestored())
		RESTORE(KGuitar)
	else {
		// no session.. just start up normally
		//
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
		config = app.config();
		
		config->setGroup("Assistant");
		bool logo = config->readBoolEntry("FirstTime", false);
		
		QPixmap picture(locate("data", "ktabedit/pics/startup.png"));
		KSplashScreen splash(picture);
		
		if (logo)
			splash.show();
		
		if (args->count() == 0) {
			KGuitar* widget = new KGuitar;
			
			app.setMainWidget(widget);
			
			widget->show();
			if (logo)
				splash.finish(widget);
			
		} else {
			for (int i = 0; i < args->count(); i++) {
				KGuitar* widget = new KGuitar;
				
				app.setMainWidget(widget);
				
				widget->show();
				widget->load(args->url(i));
				
				if (logo)
					splash.finish(widget);
			}
		}
		
		args->clear();
	}
	
	// Show tips if wanted
	//
	KTipDialog::showTip();
	
	return app.exec();
}
