/***************************************************************************
 *   Copyright (C) 2004 by Cyril Bosselut                                  *
 *   bosselut@b1project.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mp3thumbcreator.h"
#include "../libktag/libtags/tags.h"
#include <qimage.h>
#include <qbitmap.h>
#include <kdebug.h>

MP3ThumbCreator::MP3ThumbCreator() : ThumbCreator()
{
}


MP3ThumbCreator::~MP3ThumbCreator() {
}

bool MP3ThumbCreator::create(const QString &path, int width, int height, QImage &img)
{
	Tags *tags = new Tags(path);
	kdDebug("ThumbCreator") << path << endl;
	if(tags->isMP3()){
		tags->ReadId3();
	}
	else if(tags->isFLAC()){
		tags->ReadFlac();
	}
	if(tags->haveCover){
		/*QImage base(locate("data", "ktag/mask/cdmask.png"));
		QPixmap cover = (tags->cover).smoothScale(256, 256, QImage::ScaleMin);
		bitBlt(&cover, 0, 0, &base, 0,0,256,256, Qt::CopyROP);
		QBitmap mask;
		mask = base.createAlphaMask();
		cover.setMask(mask);
		img = cover.convertToImage();
		img.smoothScale(height, width, QImage::ScaleMin);*/
		img = (tags->cover).smoothScale(height, width, QImage::ScaleMin);
		
		return true;
	}
	return false;

}


