/***************************************************************************
 *   Copyright (C) 2004 by Cyril Bosselut                                  *
 *   bosselut@b1project.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "album.h"

album::album(){
	//mTracks.setAutoDelete(true);
}


album::~album(){
}

void album::setTitle(const QString& al){
	mTitle = al;
}

void album::setArtist(const QString& ar){
	mArtist = ar;
}

void album::setGenre(const QString& ge){
	mGenre = ge;
}

void album::setCover(const KURL& url){
	mCover = url;
}

void album::setYear(const int& y){
	mYear = y;
}

void album::setTrack(const int& n, const QString& ti, const QString& fi){
	KURL url;
	url.setPath(fi);
	mTracks.append(new track(n, ti, url));
}

QString album::getTitle(){
	return mTitle;
}

QString album::getArtist(){
	return mArtist;
}

QString album::getGenre(){
	return mGenre;
}

KURL album::getCover(){
	return mCover;
}

int album::getYear(){
	return mYear;
}

TrackList album::getTracks(){
	mTracks.sort();
	return mTracks;
}

track::track(const int pos, const QString& title, const KURL& url, const QString& comment){
	mPos = pos;
	mTitle = title;
	mURL = url;
	mComment = comment;
}

track::~track(){
}

int track::getPos(){
	return mPos;
}

QString track::getTitle(){
	return mTitle;
}

QString track::getComment(){
	return mComment;
}

KURL track::getURL(){
	return mURL;
}

int TrackList::compareItems( QPtrCollection::Item it1, QPtrCollection::Item it2 ){
	track* tr1 = static_cast<track*>(it1);
	track* tr2 = static_cast<track*>(it2);
	if(tr1->getPos() > tr2->getPos()){
		return 1;
	}
	else if(tr1->getPos() < tr2->getPos()){
		return -1;
	}
	return 0;
}
