/***************************************************************************
 *   Copyright (C) 2004 by Cyril Bosselut                                  *
 *   bosselut@b1project.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ALBUM_H
#define ALBUM_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <qstring.h>
#include <qptrlist.h>
#include <kurl.h>
/**
@author Cyril Bosselut
*/
class track{
	public:
		track(const int, const QString&, const KURL&, const QString& = "");
		~track();

	public:
		int getPos();
		QString getTitle();
		QString getComment();
		KURL getURL();

	private:
		int mPos;
		QString mTitle;
		QString mComment;
		KURL mURL;
};

class TrackList : virtual public QPtrList<track>{
	private:
		int compareItems( QPtrCollection::Item, QPtrCollection::Item );
};

class album{
	public:
		album();
		~album();

	public:
		void setTitle(const QString&);
		void setArtist(const QString&);
		void setGenre(const QString&);
		void setYear(const int&);
		void setTrack(const int&, const QString&, const QString&);
		void setCover(const KURL&);
		QString getTitle();
		QString getArtist();
		QString getGenre();
		KURL getCover();
		int getYear();
		TrackList getTracks();

	private:
		QString mTitle;
		QString mArtist;
		QString mGenre;
		KURL mCover;
		int mYear;
		TrackList mTracks;

};

#endif
