/***************************************************************************
 *   Copyright (C) 2004 by Cyril Bosselut                                  *
 *   bosselut@b1project.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTAGMAINWIN_H
#define KTAGMAINWIN_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <qlabel.h>
#include <qdir.h>
#include <qdragobject.h>
#include <qwidgetstack.h>
#include <qlistbox.h>
#include <qpopupmenu.h>
#include <qfileinfo.h>
#include <qvaluelist.h>
#include <qcheckbox.h>

#include <ktabwidget.h>
#include <kiconloader.h>
#include <kuniqueapplication.h>
#include <kmainwindow.h>
#include <kmessagebox.h>
#include <kstdaction.h>
#include <kaction.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kprogress.h>
#include <kconfigdialog.h>
#include <kprocess.h>
#include <kprocio.h>

#include "dcopiface.h"
#include "ktag.h"
#include "configpatterns.h"
#include "confsavepatdlg.h"
#include "playerconfig.h"
#include "mbconfig.h"
#include "prefs.h"
#include "album.h"

class Prefs;

class Players{
public:
	Players();
	~Players();

	void setProperties(const QString&, const QString&, const QString&, const QString&);
	QString getPlayer();
	QString getPlayCmd();
	QString getEnqueueCmd();
	QString getCurrentCmd();

private:
	QString player;
	QString playCmd;
	QString enqueueCmd;
	QString currentCmd;
};

class KTagMainWin : public KMainWindow, virtual public DCOPiface
{
	Q_OBJECT

public:
	KTagMainWin( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel );
	~KTagMainWin();
	KTabWidget* tabWidget;

public slots:
	void openFile( const KURL &url );
	void openFile( const QString &fp );
	void config();
	void saveFile();
	void cleanMime();
	void clearTags();
	void saveAll();
	void saveAs( const QString &p );
	void saveAllAs( const QString &p );
	void rename( const QString &p );
	void renameAll( const QString &p );
	bool chooseFile();
	void setAlbum( const QString &p );
	void setArtist( const QString &p );
	void setYear( const int );
	void setGenre( const QString &p );
	bool getAlbumCover(const QString &artist, const QString &album, const QString &folder = "");

protected:
	void dragMoveEvent( QDragMoveEvent *);
	void closeEvent(QCloseEvent *);
	void setupActions();
	void saveProperties();
	void readProperties ();

protected slots:
	void dropEvent(QDropEvent *);
	void closeTab(QWidget*);
	void setTabToolTip(QWidget*,const QString&);
	void updateTabLabel(QWidget*, bool);
	void updateTabsLabel();
	void updateStatus(QWidget*,const QString&);
	void saveAs(int i);
	void saveAllAs(int i);
	void rename(int i);
	void renameAll(int i);
	void updateFileMenu(QWidget *);
	void updateAlbumMenu(QWidget *);
	void setAlbum();
	void setArtist();
	void setYear();
	void setGenre();
	void getAlbumCover();
	void createHTML();
	album* makeAlbum(Ktag*);
	void getCurrent(int);
	void getCurrent(const QString&);
	void play(int);
	void play(const QString&);
	void enqueue(int);
	void enqueue(const QString&);
	void openFile(KProcess *, char *buffer, int buflen);

private:
	QStringList mPatterns;
	QStringList mSavePatterns;
	KRecentFilesAction *recent;
	KConfig* mConfig;
	QValueList<Players*> mPlayers;
#if HAVE_MUSICBRAINZ
	bool mAutoMB;
	QString mbServer;
	QString mbProxyServer;
	QStringList mbServerList;
	int mbProxyPort;
	int mbPort;
#endif // HAVE_MUSICBRAINZ

};

#endif // KTAGMAINWIN_H
