/***************************************************************************
 *   Copyright (C) 2004 by Cyril Bosselut                                  *
 *   bosselut@b1project.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KTAG_H_
#define _KTAG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtooltip.h>
#include <qlabel.h>
#include <qmovie.h>
#include <qpopupmenu.h>
#include <qfileinfo.h>

#include <kmainwindow.h>
#include <klocale.h>
#include <kactivelabel.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <kurlrequester.h>
#include <klineedit.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kprogress.h>
#include <klistview.h>
#include <kio/jobclasses.h>
#include "kio/job.h"
#include <kiconloader.h>

#include "libktagui/ktagdlg.h"
#include "libktagui/dlcover.h"
#include "libtags/tags.h"
#if HAVE_MUSICBRAINZ
#include "musicbrainz/musicbrainzquery.h"
#endif // HAVE_MUSICBRAINZ

/**
 * @short Application Main Window
 * @author Cyril Bosselut <bosselut@b1project.com>
 * @version 0.1
 */

class Ktag : public ktagDlg
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
	Ktag( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel );

    /**
     * Default Destructor
     */
	virtual ~Ktag();
	bool setFile( const QString &fp );
	QString mAudioFile;
	bool modified;
	void readProperties ();
	Tags *tags;
	KURL url();

private:
#if HAVE_MUSICBRAINZ
	QPopupMenu *mBrainzPopup;
#endif // HAVE_MUSICBRAINZ
	QString newFile;
	bool mbAutoSearch;
	KURL mURL;

protected:
	void dropEvent(QDropEvent *);
	void dragMoveEvent( QDragMoveEvent *);
	void closeEvent(QCloseEvent *);
	QString mbServer;
	int mbPort;
	QString mbProxyServer;
	int mbProxyPort;
	QStringList mPatterns;

private slots:
	void saveCover();
	bool readTags();
	void isModified(const QString&);
	void isModified(int);
	void downloadCover();
	void slotJobResult(KIO::Job *job);
	void slotUpdateUi( QWidget*, bool );
	QString parsefilePattern(const QString &);
#if HAVE_MUSICBRAINZ
	void mbSearch();
	void updateLists( const MusicBrainzQuery::TrackList& res );
	void updateMbList(QStringList&);
	void setFromMb(int);
	void mbPopup(QPoint);
	void mbQuery(MusicBrainzQuery*);
	void updateTip(const QString&, int);
#endif // HAVE_MUSICBRAINZ

public slots:
	void writeTags();
	void writeTags(bool);
	void cleanMime();
	void clearTags();
	void saveAs(const QString &p);
	void rename(const QString &p);

signals:
	void tabClosed( QWidget* );
	void modifiedTag( QWidget*, bool );
	void receivedDropEvent (QDropEvent *);
#if HAVE_MUSICBRAINZ
	void mbStart(QStringList& );
	void mbFound(QStringList& );
	void signalStartQuery(MusicBrainzQuery*);
	void signalStartTRM();
#endif // HAVE_MUSICBRAINZ
	void fileChanged( QWidget*,const QString& );

};

	static const char* sorted_genres[] = {
		"", "ACapella", "Acid", "Acid Jazz", "Acid Punk", "Acoustic", "Alternative", "Altern Rock", "Ambient", "Anime", "Avantgarde","Ballad", "Bass", "Beat", "Bebob", "Big Band", "Black Metal", "Bluegrass", "Blues", "Booty Bass", "Brit Pop", "Cabaret","Celtic", "Chamber Music", "Chanson", "Chorus", "Christian Gangsta Rap", "Christian Rap", "Christian Rock", "Classical","Classic Rock", "Club", "Club-House", "Comedy", "Contemporary Christian", "Country", "Crossover", "Cult", "Dance", "Dance Hall","Darkwave", "Death Metal", "Disco", "Dream", "Drum & Bass", "Drum Solo", "Duet", "Easy Listening", "Electronic", "Ethnic","Eurodance", "Euro-House", "Euro-Techno", "Fast Fusion", "Folk", "Folklore", "Folk/Rock", "Freestyle", "Funk", "Fusion","Game", "Gangsta", "Goa", "Gospel", "Gothic", "Gothic Rock", "Grunge",  "Hardcore", "Hard Rock", "Heavy Metal", "Hip-Hop","House", "Humour", "Indie", "Industrial", "Instrumental", "Instrumental Pop", "Instrumental Rock", "Jazz", "Jazz+Funk","JPop", "Jungle", "Latin", "Lo-Fi", "Meditative", "Merengue", "Metal", "Musical", "National Folk", "Native American","Neger punk", "New Age", "New Wave", "Noise", "Oldies", "Opera", "Other", "Polka", "Polsk Punk", "Pop", "Pop-Folk", "Pop/Funk","Porn Groove", "Power Ballad", "Pranks", "Primus", "Progressive Rock", "Psychadelic", "Psychedelic Rock", "Punk", "Punk Rock","Rap", "Rave", "R&B", "Reggae", "Retro", "Revival", "Rhythmic Soul", "Rock", "Rock & Roll", "Salsa", "Samba", "Satire","Showtunes", "Ska", "Slow Jam", "Slow Rock", "Sonata", "Soul", "Sound Clip", "Soundtrack", "Southern Rock", "Space", "Speech","Swing", "Symphonic Rock", "Symphony", "Synthpop", "Tango", "Techno",  "Techno-Industrial", "Terror", "Thrash Metal", "Top 40","Trailer", "Trance", "Tribal", "Trip-Hop", "Vocal", 0
	};

#endif // _KTAG_H_
