#include <kdialog.h>
#include <klocale.h>
/****************************************************************************
** Form implementation generated from reading ui file './dlcover.ui'
**
** Created: mer mai 5 20:35:51 2004
**      by: The User Interface Compiler ($Id: qt/main.cpp   3.2.3   edited May 19 14:22 $)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "dlcover.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qheader.h>
#include <klistview.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/*
 *  Constructs a dlCover as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
dlCover::dlCover( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
	if ( !name )
		setName( "dlCover" );
	setSizeGripEnabled( TRUE );
	dlCoverLayout = new QGridLayout( this, 1, 1, 11, 6, "dlCoverLayout");

	Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1");

	buttonHelp = new QPushButton( this, "buttonHelp" );
	buttonHelp->setAutoDefault( TRUE );
	Layout1->addWidget( buttonHelp );
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	Layout1->addItem( spacer );

	buttonOk = new QPushButton( this, "buttonOk" );
	buttonOk->setAutoDefault( TRUE );
	buttonOk->setDefault( TRUE );
	Layout1->addWidget( buttonOk );

	buttonCancel = new QPushButton( this, "buttonCancel" );
	buttonCancel->setAutoDefault( TRUE );
	Layout1->addWidget( buttonCancel );

	dlCoverLayout->addLayout( Layout1, 1, 0 );

	coverList = new KListView( this, "coverList" );
	coverList->addColumn( tr2i18n( "Cover" ) );
	coverList->addColumn( tr2i18n( "URL" ) );
	coverList->setResizePolicy( KListView::Default );
	coverList->setAllColumnsShowFocus( TRUE );
	coverList->setResizeMode( KListView::AllColumns );
	coverList->setFullWidth( TRUE );
	coverList->setItemsMovable( FALSE );

	dlCoverLayout->addWidget( coverList, 0, 0 );
	languageChange();
	resize( QSize(511, 304).expandedTo(minimumSizeHint()) );
	clearWState( WState_Polished );

	// signals and slots connections
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
dlCover::~dlCover()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void dlCover::languageChange()
{
    setCaption( tr2i18n( "Download Cover" ) );
    buttonHelp->setText( tr2i18n( "&Help" ) );
    buttonHelp->setAccel( QKeySequence( tr2i18n( "F1" ) ) );
    buttonOk->setText( tr2i18n( "&OK" ) );
    buttonOk->setAccel( QKeySequence( QString::null ) );
    buttonCancel->setText( tr2i18n( "&Cancel" ) );
    buttonCancel->setAccel( QKeySequence( QString::null ) );
    coverList->header()->setLabel( 0, tr2i18n( "Cover" ) );
    coverList->header()->setLabel( 1, tr2i18n( "URL" ) );
}

void dlCover::slotCoverFound(Cover* cover){
	if(!cover->getPixmap()->isNull() && coverList->findItem(cover->getUrl().url(),1) == 0){
		kdDebug("dlcover") << "Add a cover in list: " << cover->getUrl().url() << endl;
		KListViewItem* i = new KListViewItem(coverList);
		i->setPixmap(0, cover->getPixmap()->convertToImage ().smoothScale(128, 128, QImage::ScaleMin));
		i->setText(1,cover->getUrl().url());
		if(cover->getSize() > 0){
			i->setText(0, i18n("Width: %1px\nHeight: %2px\nSize: %3").arg(cover->getWidth()).arg(cover->getHeight()).arg(KIO::convertSize(cover->getSize())) );
		}
		else{
			i->setText(0, i18n("Width: %1px\nHeight: %2px\nSize: unknown").arg(cover->getWidth()).arg(cover->getHeight()) );
		}
		//coverList->hideColumn(2);
	}
	return;
}

void dlCover::testMimeType(const KURL& url){
	//KIO::Job * job = KIO::mimetype( url, false );
	//connect(job, SIGNAL(result(KIO::Job *)), this, SLOT(processMimeResult(KIO::Job *)));
	processMimeResult(url, KIO::NetAccess::mimetype( url, this));
}

void dlCover::processMimeResult(KIO::Job* job){
	KIO::MimetypeJob* mJob = static_cast<KIO::MimetypeJob*>(job);
	KURL url = mJob->url();
	if(mJob->error() != 0){
		kdDebug("dlCover") << "Job error while searching cover: " << url.url() << " " << mJob->errorText() << endl;
		return;
	}
	processMimeResult(url, mJob->mimetype());
}

void dlCover::processMimeResult(const KURL& url, const QString& dcmime){
	if( dcmime == "image/jpeg" ){
		Cover* cover = new Cover();
		kdDebug("dlCover") << "Cover found: " << url.url() << endl;
		QPixmap* pix = downloadCover(url);
		cover->setPixmap(pix);
		cover->setUrl(url);
		cover->setSize(mTmpSize);
		slotCoverFound(cover);
		return;
	}
	kdDebug("dlCover") << "Cover not found" << endl;
}

QPixmap* dlCover::downloadCover(const KURL& url){
	QString out;
	if(KIO::NetAccess::download( url, out, this )){
		QPixmap* pix = new QPixmap(out);
		mTmpSize = (KFileItem::KFileItem(out, "image/jpeg", KFileItem::Unknown)).size();
		KIO::NetAccess::removeTempFile(out);
		return pix;
	}
	QPixmap* p = new QPixmap();
	kdDebug("dlCover")<<"Error, unable to download:" << url.url()<<endl;
	return p;
}

#include "dlcover.moc"
