//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Bosselut Cyril <bosselut@b1project.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "tags.h"
/*#define _NB_GENRES ( sizeof(id3_genres)/sizeof(id3_genres[0]) )

const int Tags::NB_GENRES = _NB_GENRES;*/

Cover::Cover(){
	empty();
}

Cover::~ Cover(){
}

void Cover::empty(void){
	pixmap = new QPixmap();
	url = QString::null;
	width = -1;
	height = -1;
	size = -1;
}

void Cover::setUrl(const KURL& u){
	url = u;
}

KURL Cover::getUrl(){
	return url;
}

void Cover::setPixmap(QPixmap* p){
	pixmap = p;
	width = pixmap->width();
	height = pixmap->height();
}

QPixmap* Cover::getPixmap(){
	return pixmap;
}

int Cover::getWidth(){
	return width;
}

int Cover::getHeight(){
	return height;
}

void Cover::setSize(const int i){
	size = i;
}

int Cover::getSize(){
	return size;
}

Tags::Tags( const QString & fn ):QObject(){
	file = fn;
	KMimeMagicResult *result = KMimeMagic::self()->findFileType(file);
	mime = result->mimeType();
	haveCover = false;
}

Tags::Tags(  ):QObject(){
	haveCover = false;
}

Tags::~Tags(){
}

void Tags::setInfos(const int tr, const QString & ar, const QString & ti, const QString & al, const QString & ge, const int ye, const QString & ct, const QString & co){
	track = tr;
	artist = ar;
	stitle = ti;
	album = al;
	genre = ge;
	year = ye;
	comment = ct;
	if(co != "" && KURL(co).isValid()){
		ncover = co;
		haveCover = true;
	}
}

void Tags::setAlbum(const QString& al){
	album = al;
}

void Tags::setArtist(const QString& ar){
	artist = ar;
}

QString Tags::getMimeType(){
	return mime;
}

bool Tags::isMP3(){
	if(mime == "audio/x-mp3" || ((mime == "application/octet-stream" || mime == "audio/x-wav" || mime == "text/plain") && file.endsWith(".mp3"))){
		return true;
	}
	return false;
}

void Tags::ReadId3(){
	TagLib::MPEG::File f(file);
	rate = f.audioProperties()->bitrate();
	channel = f.audioProperties()->channels();
	int tmpfreq = f.audioProperties()->sampleRate();
	freq = (tmpfreq/1000);
	kdDebug("Tags") << "Getting tags from MP3 file:" << file << endl;
	stitle = upFirst(TStringToQString(f.tag()->title()));
	artist = upFirst(TStringToQString(f.tag()->artist()));
	album = upFirst(TStringToQString(f.tag()->album()));
	year = f.tag()->year();
	comment = TStringToQString(f.tag()->comment());
	track = f.tag()->track();
	genre = TStringToQString(f.tag()->genre());
	if(stitle != ""){
		title = artist + " - " + stitle + " - " + album;
	}
	if(f.ID3v2Tag()){
		TagLib::ID3v2::FrameList l= f.ID3v2Tag()->frameListMap()["APIC"];
		if (!l.isEmpty()){
			TagLib::ID3v2::FrameList::ConstIterator it = l.begin();
			TagLib::ID3v2::AttachedPictureFrame *p = 0l;
			while(it != l.end()){
				p =  static_cast<TagLib::ID3v2::AttachedPictureFrame *>(l.front());
				if(p->type() == TagLib::ID3v2::AttachedPictureFrame::FrontCover){
					break;
				}
				++it;
			}
			kdDebug("Tags") << "id3 have picture " << endl;
			size_t size = p->picture().size();
			kdDebug("Tags") << TStringToQString(p->mimeType()) << endl;
			kdDebug("Tags") << "Pic Type: " << p->type() << endl;
			kdDebug("Tags") << "Pic Size: " << size << endl;
			cover.loadFromData((const uchar*)p->picture().data(), size);
			haveCover = true;
		}
	}
}

void Tags::WriteId3(){
	kdDebug("Tags") << "Adding id3 tags to file " << file << endl;
	TagLib::MPEG::File f(file);
	f.tag()->setTitle(QStringToTString(stitle));
	f.tag()->setAlbum(QStringToTString(album));
	f.tag()->setArtist(QStringToTString(artist));
	f.tag()->setComment(QStringToTString(comment));
	f.tag()->setGenre(QStringToTString(genre));
	f.tag()->setYear(year);
	f.tag()->setTrack(track);
	if(haveCover && ncover != QString::null){
		kdDebug("Tags") << "Adding cover " << ncover << " in tags" << endl;
		TagLib::ID3v2::AttachedPictureFrame *p = 0l;
		TagLib::ID3v2::FrameList l= f.ID3v2Tag()->frameListMap()["APIC"];
		if (!l.isEmpty()){
			TagLib::ID3v2::FrameList::ConstIterator it = l.begin();
			while(it != l.end()){
				p =  static_cast<TagLib::ID3v2::AttachedPictureFrame *>(l.front());
				if(p->type() == TagLib::ID3v2::AttachedPictureFrame::FrontCover){
					break;
				}
				++it;
			}
		}
		else{
			p = new TagLib::ID3v2::AttachedPictureFrame;
		}
		QString out;
		if(!KURL(ncover).isLocalFile()){
			kdDebug("Tags") << "Cover is not local, downloading..." << endl;
			KIO::NetAccess::download( ncover, out, NULL );
			ncover = out;
		}
		KMimeMagicResult *result = KMimeMagic::self()->findFileType(ncover);
		if(result->mimeType() == "image/png" || result->mimeType() == "image/jpeg"){
			QString format = "JPEG";
			if(result->mimeType() == "image/png"){
				format= "PNG";
			}
			p->setMimeType(QStringToTString(result->mimeType()));
			p->setType(TagLib::ID3v2::AttachedPictureFrame::FrontCover);
			QFile file(ncover);
			file.open(IO_ReadOnly);
			QByteArray data = file.readAll();
			p->setPicture(TagLib::ByteVector(data.data(), data.size()));
			if (l.isEmpty()){
				f.ID3v2Tag()->addFrame(p);
			}
		}
		if(out){
			kdDebug("Tags") << "Remove temp file" << endl;
			KIO::NetAccess::removeTempFile(out);
		}
		ncover = QString::null;
	}
	f.save();
}

void Tags::ClearId3(){
	TagLib::MPEG::File f(file);
	f.strip(TagLib::MPEG::File::AllTags);
	setInfos(0,"","","","",0,"");
}

bool Tags::isOGG(){
	if(mime == "application/x-ogg" || mime == "audio/vorbis"){
		return true;
	}
	return false;
}

void Tags::ReadVorbis(){
	TagLib::Ogg::Vorbis::File f(file);
	if(f.isValid()){
		rate = f.audioProperties()->bitrate();
		channel = f.audioProperties()->channels();
		int tmpfreq = f.audioProperties()->sampleRate();
		freq = ((QString::number(tmpfreq).toDouble())/1000);
		kdDebug("Tags") << "Getting tags from Ogg file" << endl;
		stitle = upFirst(TStringToQString(f.tag()->title()));
		artist = upFirst(TStringToQString(f.tag()->artist()));
		album = upFirst(TStringToQString(f.tag()->album()));
		year = f.tag()->year();
		comment = TStringToQString(f.tag()->comment());
		track = f.tag()->track();
		genre = TStringToQString(f.tag()->genre());
		if(stitle != ""){
			title = artist + " - " + stitle + " - " + album;
		}
	}
}

void Tags::WriteVorbis(){
	kdDebug("Tags") << "Adding Ogg tags to file " << file << endl;
	TagLib::Ogg::Vorbis::File f(file);
	f.tag()->setTitle(QStringToTString(stitle));
	f.tag()->setAlbum(QStringToTString(album));
	f.tag()->setArtist(QStringToTString(artist));
	f.tag()->setComment(QStringToTString(comment));
	f.tag()->setGenre(QStringToTString(genre));
	f.tag()->setYear(year);
	f.tag()->setTrack(track);
	f.save();
}

void Tags::ClearVorbis(){
	TagLib::Ogg::Vorbis::File f(file);
	f.tag()->setTitle("");
	f.tag()->setAlbum("");
	f.tag()->setArtist("");
	f.tag()->setComment("");
	f.tag()->setGenre("");
	f.tag()->setYear(0);
	f.tag()->setTrack(0);
	f.save();
	setInfos(0,"","","","",0,"");
}

bool Tags::isOGGFlac(){
	if(mime == "audio/x-oggflac"){
		return true;
	}
	return false;
}

void Tags::ReadOggFlac(){
	TagLib::Ogg::FLAC::File f(file);
	if(f.isValid()){
		rate = f.audioProperties()->bitrate();
		channel = f.audioProperties()->channels();
		int tmpfreq = f.audioProperties()->sampleRate();
		freq = ((QString::number(tmpfreq).toDouble())/1000);
		kdDebug("Tags") << "Getting tags from Ogg-Flac file" << endl;
		stitle = upFirst(TStringToQString(f.tag()->title()));
		artist = upFirst(TStringToQString(f.tag()->artist()));
		album = upFirst(TStringToQString(f.tag()->album()));
		year = f.tag()->year();
		comment = TStringToQString(f.tag()->comment());
		track = f.tag()->track();
		genre = TStringToQString(f.tag()->genre());
		if(stitle != ""){
			title = artist + " - " + stitle + " - " + album;
		}
	}
}

void Tags::WriteOggFlac(){
	kdDebug("Tags") << "Adding Ogg-Flac tags to file " << file << endl;
	TagLib::Ogg::FLAC::File f(file);
	f.tag()->setTitle(QStringToTString(stitle));
	f.tag()->setAlbum(QStringToTString(album));
	f.tag()->setArtist(QStringToTString(artist));
	f.tag()->setComment(QStringToTString(comment));
	f.tag()->setGenre(QStringToTString(genre));
	f.tag()->setYear(year);
	f.tag()->setTrack(track);
	f.save();
}

void Tags::ClearOggFlac(){
	TagLib::Ogg::FLAC::File f(file);
	f.tag()->setTitle("");
	f.tag()->setAlbum("");
	f.tag()->setArtist("");
	f.tag()->setComment("");
	f.tag()->setGenre("");
	f.tag()->setYear(0);
	f.tag()->setTrack(0);
	f.save();
	setInfos(0,"","","","",0,"");
}

bool Tags::isFLAC(){
	if(mime == "audio/x-flac"){
		return true;
	}
	return false;
}

void Tags::ReadFlac(){
	TagLib::FLAC::File f(file);
	if(f.isValid()){
		rate = f.audioProperties()->bitrate();
		channel = f.audioProperties()->channels();
		int tmpfreq = f.audioProperties()->sampleRate();
		freq = ((QString::number(tmpfreq).toDouble())/1000);
		kdDebug("Tags") << "Getting tags from Flac file" << endl;
		stitle = upFirst(TStringToQString(f.tag()->title()));
		artist = upFirst(TStringToQString(f.tag()->artist()));
		album = upFirst(TStringToQString(f.tag()->album()));
		year = f.tag()->year();
		comment = TStringToQString(f.tag()->comment());
		track = f.tag()->track();
		genre = TStringToQString(f.tag()->genre());
		if(stitle != ""){
			title = artist + " - " + stitle + " - " + album;
		}
		if(f.ID3v2Tag()){
			TagLib::ID3v2::FrameList l= f.ID3v2Tag()->frameListMap()["APIC"];
			if (!l.isEmpty()){
				TagLib::ID3v2::FrameList::ConstIterator it = l.begin();
				TagLib::ID3v2::AttachedPictureFrame *p = 0l;
				while(it != l.end()){
					p =  static_cast<TagLib::ID3v2::AttachedPictureFrame *>(l.front());
					if(p->type() == TagLib::ID3v2::AttachedPictureFrame::FrontCover){
						break;
					}
					++it;
				}
				kdDebug("Tags") << "id3 have picture " << endl;
				size_t size = p->picture().size();
				kdDebug("Tags") << TStringToQString(p->mimeType()) << endl;
				kdDebug("Tags") << "Pic Type: " << p->type() << endl;
				kdDebug("Tags") << "Pic Size: " << size << endl;
				cover.loadFromData((const uchar*)p->picture().data(), size);
				haveCover = true;
			}
		}
	}
}

void Tags::WriteFlac(){
	kdDebug("Tags") << "Adding Flac tags to file " << file << endl;
	TagLib::FLAC::File f(file);
	TagLib::ID3v2::Tag *tg = f.ID3v2Tag(true);
	tg->setTitle(QStringToTString(stitle));
	tg->setAlbum(QStringToTString(album));
	tg->setArtist(QStringToTString(artist));
	tg->setComment(QStringToTString(comment));
	tg->setGenre(QStringToTString(genre));
	tg->setYear(year);
	tg->setTrack(track);
	if(haveCover && ncover != QString::null){
		kdDebug("Tags") << "Adding cover " << ncover << " in tags" << endl;
		TagLib::ID3v2::AttachedPictureFrame *p = 0l;
		TagLib::ID3v2::FrameList l= f.ID3v2Tag()->frameListMap()["APIC"];
		if (!l.isEmpty()){
			TagLib::ID3v2::FrameList::ConstIterator it = l.begin();
			while(it != l.end()){
				p =  static_cast<TagLib::ID3v2::AttachedPictureFrame *>(l.front());
				if(p->type() == TagLib::ID3v2::AttachedPictureFrame::FrontCover){
					break;
				}
				++it;
			}
		}
		else{
			p = new TagLib::ID3v2::AttachedPictureFrame;
		}
		QString out;
		if(!KURL(ncover).isLocalFile()){
			kdDebug("Tags") << "Cover is not local, downloading..." << endl;
			KIO::NetAccess::download( ncover, out, NULL );
			ncover = out;
		}
		KMimeMagicResult *result = KMimeMagic::self()->findFileType(ncover);
		if(result->mimeType() == "image/png" || result->mimeType() == "image/jpeg"){
			QString format = "JPEG";
			if(result->mimeType() == "image/png"){
				format= "PNG";
			}
			p->setMimeType(QStringToTString(result->mimeType()));
			p->setType(TagLib::ID3v2::AttachedPictureFrame::FrontCover);
			QFile file(ncover);
			file.open(IO_ReadOnly);
			QByteArray data = file.readAll();
			p->setPicture(TagLib::ByteVector(data.data(), data.size()));
			if (l.isEmpty()){
				f.ID3v2Tag()->addFrame(p);
			}
		}
		if(out){
			kdDebug("Tags") << "Remove temp file" << endl;
			KIO::NetAccess::removeTempFile(out);
		}
		ncover = QString::null;
	}
	f.save();
}

void Tags::ClearFlac(){
	TagLib::FLAC::File f(file);
	f.tag()->setTitle("");
	f.tag()->setAlbum("");
	f.tag()->setArtist("");
	f.tag()->setComment("");
	f.tag()->setGenre("");
	f.tag()->setYear(0);
	f.tag()->setTrack(0);
	f.save();
	setInfos(0,"","","","",0,"");
}

QString Tags::parsePattern(const QString& pattern){
	QString pat = pattern;
	QString ar = artist.lower().replace("'", " ").replace(",", "");
	QString aru = ar;
	aru.replace(" ", "_");
	QString nsar = ar;
	nsar.replace(" ", "");
	QString al = album.lower().replace("'", " ").replace(",", "");
	QString alu = al;
	alu.replace(" ", "_");
	QString nsal = al;
	nsal.replace(" ", "");
	QString l = ar.left(1).lower();
	QString Ar = upFirst(ar);
	QString Aru = Ar;
	Aru.replace(" ", "_");
	QString nsAr = upFirst(nsar);
	QString Al = upFirst(al);
	QString Alu = Al;
	Alu.replace(" ", "_");
	QString nsAl = upFirst(nsal);
	QString L = l.upper();
	pat.replace("%l", l).replace("%L", L).replace("%artist", ar).replace("%_artist", aru).replace("%!artist", nsar).replace("%album", al).replace("%_album", alu).replace("%!album", nsal).replace("%Artist", Ar).replace("%_Artist", Aru).replace("%!Artist", nsAr).replace("%Album", Al).replace("%_Album", Alu).replace("%!Album", nsAl);
	return pat;
}

QString Tags::upFirst( const QString & str){
	QStringList ls = 0;
	QString tmpstr = str;
	QString upstr = 0;
	ls = QStringList::split( ' ', tmpstr);
	QStringList::Iterator it = ls.begin();
	while( it!= ls.end() ){
		QString word = *it;
		QChar i = word.at(0);
		word.replace ( 0, 1, i.upper() );
		int sep = word.contains('-');
		int pos = 0;
		while(sep != 0){
			pos = word.find('-', pos)+1;
			QChar i = word.at(pos);
			word.replace ( pos, 1, i.upper() );
			sep--;
		}
		upstr += word + " " ;
		++it;
	}
	if(upstr.right(3) == " - "){
		upstr = upstr.remove(upstr.length() - 3, 3);
	}
	return upstr.stripWhiteSpace();
}

void Tags::correctMimeType(){
	KURL backup;
	backup.setPath(file);
	QString backupName = "~" + backup.fileName(false);
	backup.setFileName(backupName);
	kdDebug("Tags") << "Backup: " << backup.url() << endl;
	KIO::FileCopyJob *job = 0;
	job = KIO::file_copy(KURL(file), backup, -1, false, true, false);
	job->setAutoErrorHandlingEnabled(true);
	connect(job, SIGNAL(result(KIO::Job *)), this, SLOT(slotCleanMime(KIO::Job *)));
}

void Tags::slotCleanMime(KIO::Job *job){
	if(job->error() != 0){
		return;
	}
	KIO::FileCopyJob* mJob = static_cast<KIO::FileCopyJob*>(job);
	kdDebug("Tags") << "Backup finished" << endl;
	QFile inputFile(mJob->destURL().directory(false)+mJob->destURL().fileName());
	QFile outputFile(mJob->destURL().directory(false)+"new_"+mJob->srcURL().fileName());
	int ch;
	int backch;
	if (!inputFile.open(IO_ReadOnly)){
		kdDebug("Tags") << "Input Error! " << inputFile.name() << endl;
		return;
	}
	if (!outputFile.open(IO_WriteOnly)){
		kdDebug("Tags") << "Output Error!" << outputFile.name() << endl;
		return;
	}
	backch = inputFile.getch();
	ch = inputFile.getch();
	while(!inputFile.atEnd()){
		if (ch == 0x0a){
			if (backch == 0x0d){
				kdDebug("Tags") << "0x0a and 0x0d writing 0x0a" << endl;
				outputFile.putch(ch);
				ch = inputFile.getch();
			}
			else{
				kdDebug("Tags") << "0x0a and not 0x0d writing " << QString("%1").arg(backch,0,16) << endl;
				outputFile.putch(backch);
			}
		}
		else{
			outputFile.putch(backch);
		}
		backch = ch;
		ch = inputFile.getch();
	}
	outputFile.putch(backch);
	inputFile.close();
	outputFile.close();
	kdDebug("Tags") << "Correction finished" << endl;
}

#include "tags.moc"

